package org.arefgard.container.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.Date;

import org.arefgard.example.model.Customer;
import org.arefgard.example.model.Person;
import org.junit.Test;

public class IceryaContainerTest {
	
	/**
	 * R|[lg`t@Cp[XāÃIuWFNg𐶐ł
	 * ƂmFB
	 */
	@Test
	public void getSimpleBean() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/container/core/components01.dix");
			Date date = (Date)container.getBean("now");
			assertNotNull(date);
			String userId = (String)container.getBean("userId");
			assertNotNull(userId);
			assertEquals("", userId);
			String password = (String)container.getBean("userId");
			assertNotNull(password);
			assertEquals("", password);
		}catch(ContainerException e) {
			fail("");
		}
	}
	
	@Test
	public void getBeanWithProperty() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/container/core/components02.dix");
			Customer customer = (Customer)container.getBean("customer");
			assertEquals("0001", customer.getCustomerId());
			assertEquals("Yamada", customer.getFirstName());
			assertEquals("Taro", customer.getLastName());
			assertEquals(1, customer.getAge());
		}catch(ContainerException e) {
			fail("");
		}
	}
	
	@Test
	public void getBeanWithRefProperty() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/container/core/components03.dix");
			Person person = (Person)container.getBean("person");
			assertEquals("Yamada", person.getFullName().getFirstName());
			assertEquals("Taro", person.getFullName().getLastName());
			assertEquals(1, person.getAge());
		}catch(ContainerException e) {
			fail("");
		}
	}
}
