/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class FileSystemComponentAutoRegister
extends AbstractComponentAutoRegister {
    public void registerAll() {
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            this.register(cp);
        }
    }

    protected void register(final ClassPattern classPattern) {
        String packageName = classPattern.getPackageName();
        File packageDir = this.getRootDir();
        ClassTraversal.forEach(packageDir, packageName, new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                if (FileSystemComponentAutoRegister.this.isIgnore(packageName, shortClassName)) {
                    return;
                }
                if (classPattern.isAppliedPackageName(packageName) && classPattern.isAppliedShortClassName(shortClassName)) {
                    FileSystemComponentAutoRegister.this.register(ClassUtil.concatName(packageName, shortClassName));
                }
            }
        });
    }

    protected File getRootDir() {
        String path = this.getContainer().getPath();
        File file = ResourceUtil.getResourceAsFile(path);
        String[] names = StringUtil.split(path, "/");
        for (int i = 0; i < names.length; ++i) {
            file = file.getParentFile();
        }
        return file;
    }
}

