/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.external.servlet.CookieMap;
import org.seasar.framework.container.external.servlet.HttpSessionMap;
import org.seasar.framework.container.external.servlet.ServletApplicationMap;
import org.seasar.framework.container.external.servlet.ServletInitParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderValuesMap;
import org.seasar.framework.container.external.servlet.ServletRequestMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterValuesMap;
import org.seasar.framework.exception.EmptyRuntimeException;

public class HttpServletExternalContext
implements ExternalContext {
    private ThreadLocal requests = new ThreadLocal();
    private ThreadLocal responses = new ThreadLocal();
    private ServletContext application;

    public Object getRequest() {
        return this.getHttpServletRequest();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.requests.get();
    }

    public void setRequest(Object request) {
        this.requests.set(request);
    }

    public Object getResponse() {
        return this.responses.get();
    }

    public void setResponse(Object response) {
        this.responses.set(response);
    }

    public Object getSession() {
        return this.getHttpSession();
    }

    protected HttpSession getHttpSession() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new EmptyRuntimeException("request");
        }
        return request.getSession();
    }

    public Object getApplication() {
        return this.application;
    }

    public void setApplication(Object application) {
        if (!(application instanceof ServletContext)) {
            throw new IllegalArgumentException("application:" + application);
        }
        this.application = (ServletContext)application;
    }

    public Map getApplicationMap() {
        return new ServletApplicationMap(this.application);
    }

    public Map getInitParameterMap() {
        return new ServletInitParameterMap(this.application);
    }

    public Map getRequestCookieMap() {
        return new CookieMap(this.getHttpServletRequest());
    }

    public Map getRequestHeaderMap() {
        return new ServletRequestHeaderMap(this.getHttpServletRequest());
    }

    public Map getRequestHeaderValuesMap() {
        return new ServletRequestHeaderValuesMap(this.getHttpServletRequest());
    }

    public Map getRequestMap() {
        return new ServletRequestMap((ServletRequest)this.getHttpServletRequest());
    }

    public Map getRequestParameterMap() {
        return new ServletRequestParameterMap((ServletRequest)this.getHttpServletRequest());
    }

    public Map getRequestParameterValuesMap() {
        return new ServletRequestParameterValuesMap((ServletRequest)this.getHttpServletRequest());
    }

    public Map getSessionMap() {
        return new HttpSessionMap(this.getHttpServletRequest());
    }
}

