/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.ShortConversionUtil;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static Object[] add(Object[] array, Object obj) {
        if (array == null) {
            throw new EmptyRuntimeException("array");
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = obj;
        return newArray;
    }

    public static Object[] add(Object[] a, Object[] b) {
        if (a != null && b != null) {
            if (a.length != 0 && b.length != 0) {
                Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
                System.arraycopy(a, 0, array, 0, a.length);
                System.arraycopy(b, 0, array, a.length, b.length);
                return array;
            }
            if (b.length == 0) {
                return a;
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        return b;
    }

    public static int indexOf(Object[] array, Object obj) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                if (!(o != null ? o.equals(obj) : obj == null)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char ch) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                char c = array[i];
                if (ch != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static Object[] remove(Object[] array, Object obj) {
        int index = ArrayUtil.indexOf(array, obj);
        if (index < 0) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }

    public static boolean isEmpty(Object[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean contains(Object[] array, Object obj) {
        return -1 < ArrayUtil.indexOf(array, obj);
    }

    public static boolean contains(char[] array, char ch) {
        return -1 < ArrayUtil.indexOf(array, ch);
    }

    public static boolean equalsIgnoreSequence(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        List<Object> list = Arrays.asList(array2);
        for (int i = 0; i < array1.length; ++i) {
            Object o1 = array1[i];
            if (list.contains(o1)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) {
                sb.append('[');
            } else {
                sb.append(", ");
            }
            sb.append(String.valueOf(array[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static void setArrayValue(Object array, Class valueType, Object value, int index) {
        if (value == null) {
            return;
        }
        if (valueType == Integer.TYPE) {
            Array.setInt(array, index, IntegerConversionUtil.toPrimitiveInt(value));
        } else if (valueType == Double.TYPE) {
            Array.setDouble(array, index, DoubleConversionUtil.toPrimitiveDouble(value));
        } else if (valueType == Long.TYPE) {
            Array.setLong(array, index, LongConversionUtil.toPrimitiveLong(value));
        } else if (valueType == Float.TYPE) {
            Array.setFloat(array, index, FloatConversionUtil.toPrimitiveFloat(value));
        } else if (valueType == Short.TYPE) {
            Array.setShort(array, index, ShortConversionUtil.toPrimitiveShort(value));
        } else if (valueType == Boolean.TYPE) {
            Array.setBoolean(array, index, BooleanConversionUtil.toPrimitiveBoolean(value));
        } else if (valueType == Character.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        }
        Array.set(array, index, value);
    }

    public static Object[] toObjectArray(Object obj) {
        int length = Array.getLength(obj);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(obj, i);
        }
        return array;
    }
}

