package org.arefgard.flow.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.arefgard.flow.exception.UsecaseFlowDefinitionParseException;
import org.arefgard.flow.exception.UsecaseFlowException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * XMLŒ`ꂽ[XP[Xt[`t@Cp[XB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class UsecaseFlowDefinitionReader {
	
	/** p[Xi[郆[XP[Xt[ */
	private UsecaseFlow flow;
	
	/**
	 * RXgN^B
	 * 
	 * @param flow
	 */
	public UsecaseFlowDefinitionReader(UsecaseFlow flow) {
		this.flow = flow;
	}
	
	/**
	 * [XP[Xt[`t@Cp[XB
	 * 
	 * @param path [XP[Xt[`t@C̃pX
	 * @throws UsecaseFlowException [XP[Xt[`t@C̃p[XɎsꍇ
	 */
	public void parse(String path) throws UsecaseFlowException {
		
		// SAXp[T̎擾
		XMLReader reader = null;
		try {
			reader = XMLReaderFactory.createXMLReader();
		} catch (SAXException e) {
			e.printStackTrace();
			throw new UsecaseFlowDefinitionParseException("Creation XMLReader failed.", e);
		}
		
		// nh̐ݒ
		reader.setContentHandler(new FlowHandler(flow));
		InputStream is = ClassLoader.getSystemResourceAsStream(path);
		if(is == null) {
			is = this.getClass().getClassLoader().getResourceAsStream(path);
		}

		try {
			reader.parse(new InputSource(is));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
		} catch (IOException e) {
			e.printStackTrace();
			throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
		} catch (SAXException e) {
			e.printStackTrace();
			throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
		}finally {
			try {
				if(is != null) {
					is.close();
				}
			}catch(Exception ignored) {}
		}
	}
}
