package org.arefgard.flow.integration;

import org.arefgard.flow.exception.DIContainerNotSupportedException;
import org.arefgard.flow.exception.UsecaseFlowException;
import org.arefgard.flow.integration.icerya.DIContainerIcerya;
import org.arefgard.flow.integration.seasar2.DIContainerSeasar2;
import org.arefgard.flow.integration.spring.DIContainerSpring;
import org.arefgard.flow.util.FileUtil;

/**
 * DIRei𐶐t@NgB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class DIContainerFactory {
	
	/**
	 * DIRei𐶐B
	 * <br/>
	 * <br/>
	 * DIRei̒`t@C̊gqdicon̏ꍇseasar2ṕA
	 * xml̏ꍇSpringṕAdix̏ꍇIceryaContainerpDI
	 * ReiIuWFNgԂB
	 * @param path DIReĩpX(NXpX)
	 * @return DIRei
	 * @throws UsecaseFlowException T|[gĂȂDIReiw肳ꂽꍇ
	 */
	public static DIContainer createContainer(String path) throws UsecaseFlowException {
		DIContainer container = null;
		if(FileUtil.getExtension(path).equals("dicon")) {
			container = new DIContainerSeasar2(path);
		}else if(FileUtil.getExtension(path).equals("xml")) {
			container = new DIContainerSpring(path);
		}else if(FileUtil.getExtension(path).equals("dix")) {
			container = new DIContainerIcerya(path);
		}else {
			throw new DIContainerNotSupportedException();
		}
		return container;
	}
}
