package org.arefgard.flow.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.arefgard.flow.exception.UsecaseFlowException;
import org.junit.Test;


public class UsecaseFlowTest {
	@Test
	public void executeUsecaseWithS2Container() {
		try {
			UsecaseFlow flow = UsecaseFlowFactory.create("example/flow/seasar2/calc.ucf");
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "+");
			flow.execute();
			int ret = (Integer)flow.getOutput("return");
			flow.clear();
			assertEquals(150, ret);
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "-");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(50, ret);
			flow.clear();
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "*");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(5000, ret);
			flow.clear();
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "/");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(2, ret);
		}catch(UsecaseFlowException e) {
			e.printStackTrace();
			fail("");
		}catch(Exception e) {
			e.printStackTrace();
			fail("");
		}
	}
	
	@Test
	public void executeUsecaseWithSpring() {
		try {
			UsecaseFlow flow = UsecaseFlowFactory.create("example/flow/spring/calc.ucf");
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "+");
			flow.execute();
			int ret = (Integer)flow.getOutput("return");
			flow.clear();
			assertEquals(150, ret);
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "-");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(50, ret);
			flow.clear();
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "*");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(5000, ret);
			flow.clear();
			flow.addInput("left", 100);
			flow.addInput("right", 50);
			flow.addInput("expr", "/");
			flow.execute();
			ret = (Integer)flow.getOutput("return");
			assertEquals(2, ret);
		}catch(UsecaseFlowException e) {
			e.printStackTrace();
			fail("");
		}catch(Exception e) {
			e.printStackTrace();
			fail("");
		}
	}
	
	@Test
	public void executeUsecaseInherit() {
		try {
			UsecaseFlow flow1 = UsecaseFlowFactory.create("example/flow/inherit/super-flow.ucf");
			flow1.addInput("message", "test message.");
			flow1.execute();
			UsecaseFlow flow2 = UsecaseFlowFactory.create("example/flow/inherit/sub-flow.ucf");
			flow2.addInput("message", "test message.");
			flow2.execute();
		}catch(UsecaseFlowException e) {
			e.printStackTrace();
			fail("");
		}catch(Exception e) {
			e.printStackTrace();
			fail("");
		}
	}
	
	
}
