package org.arefgard.icerya.container.core;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * Beanp[X邽߂ContentHandlerB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class BeanHandler implements ContentHandler {
	
	private static final String NODE_BEAN = "bean";
	private static final String NODE_PROPERTY = "property";
	private static final String ATTR_ID = "id";
	private static final String ATTR_CLASS = "class";
	private static final String ATTR_NAME = "name";
	
	private String nowBean;
	private String nowProperty;
	private IceryaContainer container;
	
	public BeanHandler(IceryaContainer container) {
		this.container = container;
	}
	
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if(nowBean != null && nowProperty == null) {
			BeanEntity now = this.container.getBeanEntity(nowBean);
			now.setContext(new String(ch, start, length).trim());
		}else if(nowBean != null && nowProperty != null) {
			BeanEntity now = this.container.getBeanEntity(nowBean);
			now.addProperty(nowProperty, new String(ch, start, length).trim());
		}
	}

	public void endDocument() throws SAXException {

	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if(qName.equals(NODE_BEAN)) {
			// <bean>
			this.nowBean = null;
		}else if(qName.equals(NODE_PROPERTY)) {
			// <property>
			this.nowProperty = null;
		}
	}

	public void endPrefixMapping(String prefix) throws SAXException {

	}

	public void ignorableWhitespace(char[] ch, int start, int length)
			throws SAXException {

	}

	public void processingInstruction(String target, String data)
			throws SAXException {

	}

	public void setDocumentLocator(Locator locator) {

	}

	public void skippedEntity(String name) throws SAXException {

	}

	public void startDocument() throws SAXException {

	}

	public void startElement(String uri, String localName, String qName,
			Attributes atts) throws SAXException {
		if(qName.equals(NODE_BEAN)) {
			// <bean>
			BeanEntity beanEntity = new BeanEntity();
			String id = atts.getValue(ATTR_ID);
			if(id == null || id.isEmpty()) {
				throw new SAXException("bean tag's id attribute is reqired.");
			}
			beanEntity.setBeanId(id);
			String cls = atts.getValue(ATTR_CLASS);
			if(cls == null || cls.isEmpty()) {
				throw new SAXException("bean tag's class attribute is required.");
			}
			beanEntity.setBeanClass(cls);
			this.nowBean = beanEntity.getBeanId();
			this.container.addBeanEntity(beanEntity);
		}else if(qName.equals(NODE_PROPERTY)) {
			// <property>
			String name = atts.getValue(ATTR_NAME);
			if(name == null || name.isEmpty()) {
				throw new SAXException("property tag's name attribute is required.");
			}
			this.nowProperty = name;
		}

	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {

	}

}
