/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.flow.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.arefgard.flow.exception.IllegalVariableException;
import org.arefgard.flow.exception.UsecaseFlowException;
import org.arefgard.flow.exception.UsecaseFlowExecuteException;
import org.arefgard.flow.node.DecisionNode;
import org.arefgard.flow.node.IncludeNode;
import org.arefgard.flow.node.InvokeNode;
import org.arefgard.flow.node.Node;
import org.arefgard.flow.node.ReceiveNode;
import org.arefgard.flow.node.ReplyNode;
import org.arefgard.flow.node.ThrowNode;
import org.arefgard.flow.node.WaitNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsecaseFlow {
    private String path;
    private String extendsUsecase;
    private Map<String, String> variables = new HashMap<String, String>();
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Map<String, Object> inputs = new HashMap<String, Object>();
    private Map<String, Object> outputs = new HashMap<String, Object>();
    private String startNode;
    private String endNode;

    String getContainerPath() {
        return this.path;
    }

    void setContainerPath(String path) {
        this.path = path;
    }

    String getExtends() {
        return this.extendsUsecase;
    }

    void setExtends(String extendsUsecase) {
        this.extendsUsecase = extendsUsecase;
    }

    void addVar(String name, String className) {
        this.variables.put(name, className);
    }

    String getVar(String name) {
        return this.variables.get(name);
    }

    void addNode(Node node) {
        if (node instanceof ReceiveNode) {
            ReceiveNode receiveNode = (ReceiveNode)node;
            int i = 0;
            int n = receiveNode.getPropertySize();
            while (i < n) {
                this.variables.containsKey(receiveNode.getProperty(i));
                ++i;
            }
            this.startNode = node.getName();
        } else if (node instanceof ReplyNode) {
            ReplyNode replyNode = (ReplyNode)node;
            int i = 0;
            int n = replyNode.getPropertySize();
            while (i < n) {
                this.variables.containsKey(replyNode.getProperty(i));
                ++i;
            }
        }
        this.nodes.put(node.getName(), node);
    }

    Node getNode(String name) {
        return this.nodes.get(name);
    }

    public void addInput(String name, Object obj) throws UsecaseFlowException {
        ReceiveNode node = (ReceiveNode)this.nodes.get(this.startNode);
        if (!node.containsProperty(name)) {
            throw new IllegalVariableException(String.valueOf(name) + "is illeagal input.");
        }
        this.inputs.put(name, obj);
    }

    public void setInputs(Map<String, Object> inputs) throws UsecaseFlowException {
        Set<String> keys = inputs.keySet();
        for (String key : keys) {
            if (this.inputs.containsKey(key)) continue;
            throw new IllegalVariableException(String.valueOf(key) + " is illeagal input.");
        }
        this.inputs = inputs;
    }

    public Object getOutput(String name) throws UsecaseFlowException {
        ReplyNode node = (ReplyNode)this.nodes.get(this.endNode);
        if (node.containsProperty(name)) {
            return this.outputs.get(name);
        }
        throw new IllegalVariableException(String.valueOf(name) + " is illeagal output.");
    }

    public void execute() throws UsecaseFlowException, Exception {
        ReceiveNode start = (ReceiveNode)this.nodes.get(this.startNode);
        String nextTo = start.getNextTo();
        Node node = null;
        while (true) {
            if ((node = this.nodes.get(nextTo)) instanceof InvokeNode) {
                InvokeNode invokeNode = (InvokeNode)node;
                invokeNode.invoke(this.path, this.inputs);
                nextTo = invokeNode.getNextTo();
                continue;
            }
            if (node instanceof DecisionNode) {
                DecisionNode decisionNode = (DecisionNode)node;
                nextTo = decisionNode.decide(this.inputs);
                continue;
            }
            if (node instanceof WaitNode) {
                WaitNode waitNode = (WaitNode)node;
                try {
                    waitNode.doWait();
                }
                catch (InterruptedException e) {
                    throw new UsecaseFlowExecuteException("Wait interruped.", e);
                }
                nextTo = waitNode.getNextTo();
                continue;
            }
            if (node instanceof ThrowNode) {
                ThrowNode throwNode = (ThrowNode)node;
                throwNode.throwException();
                continue;
            }
            if (node instanceof IncludeNode) {
                IncludeNode includeNode = (IncludeNode)node;
                includeNode.call(this.inputs);
                continue;
            }
            if (node instanceof ReplyNode) break;
        }
        ReplyNode replyNode = (ReplyNode)node;
        int i = 0;
        int n = replyNode.getPropertySize();
        while (i < n) {
            this.outputs.put(replyNode.getProperty(i), this.inputs.get(replyNode.getProperty(i)));
            ++i;
        }
        this.endNode = replyNode.getName();
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
    }
}

