/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.flow.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.arefgard.icerya.flow.exception.IllegalVariableException;
import org.arefgard.icerya.flow.exception.UsecaseFlowException;
import org.arefgard.icerya.flow.node.Flow;
import org.arefgard.icerya.flow.node.ReceiveNode;
import org.arefgard.icerya.flow.node.ReplyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsecaseFlow {
    private static final String MAIN_FLOW = "_main";
    private String path;
    private String extendsUsecase;
    private Map<String, String> variables = new HashMap<String, String>();
    private Map<String, Flow> flows = new HashMap<String, Flow>();
    private Exception throwable = null;
    private boolean finished = false;

    public Exception getTrowable() {
        return this.throwable;
    }

    public void setThrowable(Exception throwable) {
        this.throwable = throwable;
    }

    public String getContainerPath() {
        return this.path;
    }

    void setContainerPath(String path) {
        this.path = path;
    }

    String getExtends() {
        return this.extendsUsecase;
    }

    void setExtends(String extendsUsecase) {
        this.extendsUsecase = extendsUsecase;
    }

    void addVar(String name, String className) {
        this.variables.put(name, className);
    }

    String getVar(String name) {
        return this.variables.get(name);
    }

    public void addFlow(String name, Flow flow) {
        this.flows.put(name, flow);
    }

    public Flow getFlow(String name) {
        return this.flows.get(name);
    }

    public void addInput(String name, Object obj) throws UsecaseFlowException {
        ReceiveNode node = (ReceiveNode)this.flows.get(MAIN_FLOW).getStartNode();
        if (!node.containsProperty(name)) {
            throw new IllegalVariableException(String.valueOf(name) + "is illeagal input.");
        }
        this.flows.get(MAIN_FLOW).addInput(name, obj);
    }

    public void setInputs(Map<String, Object> inputs) throws UsecaseFlowException {
        Set<String> keys = this.flows.get(MAIN_FLOW).getInputs().keySet();
        for (String key : keys) {
            if (this.flows.get(MAIN_FLOW).getInputs().containsKey(key)) continue;
            throw new IllegalVariableException(String.valueOf(key) + " is illeagal input.");
        }
        this.flows.get(MAIN_FLOW).setInputs(inputs);
    }

    public Object getOutput(String name) throws UsecaseFlowException {
        ReplyNode node = (ReplyNode)this.flows.get(MAIN_FLOW).getEndNode();
        if (node.containsProperty(name)) {
            return this.flows.get(MAIN_FLOW).getOutputs().get(name);
        }
        throw new IllegalVariableException(String.valueOf(name) + " is illeagal output.");
    }

    public Map<String, Object> getOutputs() throws UsecaseFlowException {
        return this.flows.get(MAIN_FLOW).getOutputs();
    }

    public void executeAsync() throws UsecaseFlowException, Exception {
        Flow flow = this.getFlow(MAIN_FLOW);
        flow.start();
    }

    public Map<String, Object> executeSync() throws UsecaseFlowException, Exception {
        Flow flow = this.getFlow(MAIN_FLOW);
        flow.execute();
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.flows.get(MAIN_FLOW).getOutputs();
    }

    public void clear() {
        this.flows.get(MAIN_FLOW).clear();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

