/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.flow.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static Object generate(String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException("\u30af\u30e9\u30b9\u300c" + className + "\u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", e);
        }
    }

    public static void setProperty(Object obj, String property, Object value) throws Exception {
        Class<?> clazz = obj.getClass();
        StringBuffer methodName = new StringBuffer("set");
        methodName.append(property.substring(0, 1).toUpperCase());
        methodName.append(property.substring(1));
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        int n = methods.length;
        while (i < n) {
            if (methods[i].getName().equals(methodName.toString())) {
                method = methods[i];
                break;
            }
            ++i;
        }
        method.invoke(obj, value);
    }

    public static Object getProperty(Object obj, String property) throws Exception {
        Class<?> clazz = obj.getClass();
        StringBuffer methodName = new StringBuffer("get");
        methodName.append(property.substring(0, 1).toUpperCase());
        methodName.append(property.substring(1));
        Method method = clazz.getDeclaredMethod(methodName.toString(), new Class[0]);
        return method.invoke(obj, new Object[0]);
    }

    public static Object execute(Object obj, String methodName, List<Object> parameter) throws Exception {
        Class<?> clazz = obj.getClass();
        Method method = null;
        if (parameter == null) {
            method = clazz.getDeclaredMethod(methodName, null);
            method.setAccessible(true);
            return method.invoke(obj, null);
        }
        Object[] objList = parameter.toArray();
        Class[] classList = new Class[objList.length];
        int i = 0;
        while (i < objList.length) {
            classList[i] = objList[i].getClass();
            ++i;
        }
        Method[] methods = clazz.getDeclaredMethods();
        int i2 = 0;
        int n = methods.length;
        while (i2 < n) {
            if (methods[i2].getName().equals(methodName.toString())) {
                method = methods[i2];
                break;
            }
            ++i2;
        }
        return method.invoke(obj, objList);
    }

    public static Object convertObject(Object obj, String fieldName, String value) throws Exception {
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (type.getName().equals("byte") || type.getName().equals("java.lang.Byte")) {
            return new Byte(value);
        }
        if (type.getName().equals("short") || type.getName().equals("java.lang.Short")) {
            return new Short(value);
        }
        if (type.getName().equals("int") || type.getName().equals("java.lang.Integer")) {
            return new Integer(value);
        }
        if (type.getName().equals("long") || type.getName().equals("java.lang.Long")) {
            return new Long(value);
        }
        if (type.getName().equals("float") || type.getName().equals("java.lang.Float")) {
            return new Float(value);
        }
        if (type.getName().equals("double") || type.getName().equals("java.lang.Double")) {
            return new Double(value);
        }
        if (type.getName().equals("char") || type.getName().equals("java.lang.Character")) {
            return new Character(value.toCharArray()[0]);
        }
        return value;
    }
}

