/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.autodetector.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.seasar.framework.autodetector.ResourceAutoDetector;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.ZipFileUtil;

public abstract class AbstractResourceAutoDetector
implements ResourceAutoDetector {
    private Map strategies = new HashMap();
    private List targetDirPaths = new ArrayList();
    private List resourceNamePatterns = new ArrayList();
    private List ignoreResourceNamePatterns = new ArrayList();

    public AbstractResourceAutoDetector() {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
        this.strategies.put("zip", new ZipFileStrategy());
    }

    public void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(URLUtil.toCanonicalProtocol(protocol));
    }

    public void addTargetDirPath(String targetDirPath) {
        this.targetDirPaths.add(targetDirPath);
    }

    public int getTargetDirPathSize() {
        return this.targetDirPaths.size();
    }

    public String getTargetDirPath(int index) {
        return (String)this.targetDirPaths.get(index);
    }

    public void addResourceNamePattern(String resourceName) {
        this.resourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public void addIgnoreResourceNamePattern(String resourceName) {
        this.ignoreResourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public Pattern getResourceNamePattern(int index) {
        return (Pattern)this.resourceNamePatterns.get(index);
    }

    public int getResourceNamePatternSize() {
        return this.resourceNamePatterns.size();
    }

    public Pattern getIgnoreResourceNamePattern(int index) {
        return (Pattern)this.ignoreResourceNamePatterns.get(index);
    }

    public int getIgnoreResourceNamePatternSize() {
        return this.ignoreResourceNamePatterns.size();
    }

    protected boolean isApplied(String resourceName) {
        for (int i = 0; i < this.getResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnored(String resourceName) {
        for (int i = 0; i < this.getIgnoreResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getIgnoreResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public String getBaseName(String path, URL url) {
            return this.createJarFile(url).getName();
        }

        public void detect(String path, URL url, ResourceTraversal.ResourceHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            ResourceTraversal.forEach(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            String jarFileName = ZipFileUtil.toZipFilePath(url);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public String getBaseName(String path, URL url) {
            return this.createJarFile(url).getName();
        }

        public void detect(String path, URL url, ResourceTraversal.ResourceHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            ResourceTraversal.forEach(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile(url);
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public String getBaseName(String path, URL url) {
            File rootDir = this.getRootDir(path, url);
            return FileUtil.getCanonicalPath(rootDir);
        }

        public void detect(String path, URL url, ResourceTraversal.ResourceHandler handler) {
            File rootDir = this.getRootDir(path, url);
            ResourceTraversal.forEach(rootDir, path, handler);
        }

        protected File getRootDir(String path, URL url) {
            File file = ResourceUtil.getFile(url);
            String[] names = StringUtil.split(path, "/");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public String getBaseName(String var1, URL var2);

        public void detect(String var1, URL var2, ResourceTraversal.ResourceHandler var3);
    }
}

