/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BridgeMethodResolver {
    static /* synthetic */ Class class$java$lang$Object;

    public static Method findBridgedMethod(Method bridgeMethod) {
        Assert.notNull(bridgeMethod, "Method must not be null");
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < methods.length; ++i) {
            Method candidateMethod = methods[i];
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        Method result = candidateMethods.size() == 1 ? (Method)candidateMethods.get(0) : BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
        if (result == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + bridgeMethod + "'");
        }
        return result;
    }

    private static Method searchCandidates(List candidateMethods, Method bridgeMethod) {
        Map typeParameterMap = BridgeMethodResolver.createTypeVariableMap(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < candidateMethods.size(); ++i) {
            Method candidateMethod = (Method)candidateMethods.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) continue;
            return candidateMethod;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map typeVariableMap) {
        if (BridgeMethodResolver.isResolvedTypeMatch(candidateMethod, bridgeMethod, typeVariableMap)) {
            return true;
        }
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null ? BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap) : false;
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(superclass)) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            superclass = superclass.getSuperclass();
        }
        Class[] interfaces = ClassUtils.getAllInterfacesForClass(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            Method method = BridgeMethodResolver.searchForMatch(anInterface, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map typeVariableMap) {
        Class<?>[] candidateParameters;
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        if (genericParameters.length != (candidateParameters = candidateMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < genericParameters.length; ++i) {
            Type genericParameter = genericParameters[i];
            Class<?> candidateParameter = candidateParameters[i];
            if (!(genericParameter instanceof GenericArrayType && candidateParameter.isArray() ? !candidateParameter.getComponentType().equals(BridgeMethodResolver.getRawType(((GenericArrayType)genericParameter).getGenericComponentType(), typeVariableMap)) : !candidateParameter.equals(BridgeMethodResolver.getRawType(genericParameter, typeVariableMap)))) continue;
            return false;
        }
        return true;
    }

    private static Type getRawType(Type genericType, Map typeVariableMap) {
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            return (Type)typeVariableMap.get(tv.getName());
        }
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getRawType();
        }
        return genericType;
    }

    private static Method searchForMatch(Class type, Method bridgeMethod) {
        return ReflectionUtils.findMethod(type, bridgeMethod.getName(), bridgeMethod.getParameterTypes());
    }

    static Map createTypeVariableMap(Class cls) {
        ParameterizedType pt;
        HashMap typeVariableMap = new HashMap();
        BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(cls.getGenericInterfaces(), typeVariableMap);
        Type genericType = cls.getGenericSuperclass();
        Class<Object> type = cls.getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(type)) {
            if (genericType instanceof ParameterizedType) {
                pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
            }
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(type.getGenericInterfaces(), typeVariableMap);
            genericType = type.getGenericSuperclass();
            type = type.getSuperclass();
        }
        type = cls;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
            }
            type = type.getEnclosingClass();
        }
        return typeVariableMap;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map typeVariableMap) {
        for (int i = 0; i < genericInterfaces.length; ++i) {
            Type genericInterface = genericInterfaces[i];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
        }
    }

    private static void populateTypeMapFromParameterizedType(Map typeVariableMap, ParameterizedType type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            TypeVariable typeVariableArgument;
            Class boundClass;
            Type actualTypeArgument = actualTypeArguments[i];
            if (actualTypeArgument instanceof Class) {
                typeVariableMap.put(typeVariables[i].getName(), (Class)actualTypeArgument);
                continue;
            }
            if (actualTypeArgument instanceof ParameterizedType) {
                typeVariableMap.put(typeVariables[i].getName(), ((ParameterizedType)actualTypeArgument).getRawType());
                continue;
            }
            if (!(actualTypeArgument instanceof TypeVariable) || (boundClass = BridgeMethodResolver.extractClassTypeVariable(typeVariableArgument = (TypeVariable)actualTypeArgument)) == null) continue;
            typeVariableMap.put(typeVariables[i].getName(), boundClass);
        }
    }

    private static Class extractClassTypeVariable(TypeVariable typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        Type result = null;
        if (bounds.length > 0) {
            Type bound = bounds[0];
            if (bound instanceof ParameterizedType) {
                result = ((ParameterizedType)bound).getRawType();
            } else if (bound instanceof Class) {
                result = bound;
            } else if (bound instanceof TypeVariable) {
                result = BridgeMethodResolver.extractClassTypeVariable((TypeVariable)bound);
            }
        }
        return result instanceof Class ? (Class)result : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

