package org.arefgard.icerya.flow.core;

import java.util.Map;

import org.arefgard.icerya.flow.exception.UsecaseFlowException;

/**
 * [XP[Xt[𐶐t@NgB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class UsecaseFlowFactory {
	
	/** [XP[Xt[̃LbV */
	private static Map<String, UsecaseFlow> cache = new java.util.HashMap<String, UsecaseFlow>();
	
	/**
	 * [XP[Xt[𐶐B
	 * <br/>
	 * <br/>
	 * [XP[Xt[`t@Cp[XāA[XP[Xt[IuWFNg𐶐B
	 * pX̃[XP[XLbVĂ΁AԂB
	 * 
	 * @param path [XP[Xt[̃pX
	 * @return [XP[Xt[̃IuWFNg
	 * @throws UsecaseFlowException [XP[Xt[IuWFNg̐Ɏsꍇ
	 */
	public synchronized static UsecaseFlow create(String path) throws UsecaseFlowException {
		
		UsecaseFlow result = null;
		if(cache.containsKey(path)) {
			// LbVĂ
			result = cache.get(path);
		}else {
			result = new UsecaseFlow();
			UsecaseFlowDefinitionReader reader = new UsecaseFlowDefinitionReader(result);
			reader.parse(path);
			cache.put(path, result);
		}
		return result;

	}
}
