package org.arefgard.icerya.flow.node;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.arefgard.icerya.flow.core.UsecaseExpression;

/**
 * \m[hB
 * 
 * @author Takashi Yamashi
 * @since 1.0.0
 */
public class DecisionNode extends Node {
	
	/** }bv */
	private Map<String, String> navigations = new java.util.HashMap<String, String>();
	
	public void addProperty(String condition, String nextTo) {
		this.navigations.put(condition, nextTo);
	}

	/**
	 * [XP[Xt[̏ԂJڐ肷B
	 * 
	 * @param params [XP[Xt[̏
	 * @return Jڐ
	 */
	public String decide(Map<String, Object> params) {
		Set<String> keys = this.navigations.keySet();
		
		for(Iterator<String> itr = keys.iterator(); itr.hasNext();) {
			String navi = itr.next();
			String nextTo = this.navigations.get(navi);
			UsecaseExpression expression = new UsecaseExpression(navi);
			expression.setArgs(params);
			if(expression.evaluateBoolean()) {
				return nextTo;
			}

		}
		return null;
	}
}
