/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.core;

import java.util.HashMap;
import java.util.Map;
import org.arefgard.icerya.container.core.BeanCreateException;
import org.arefgard.icerya.container.core.BeanEntity;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.util.ReflectionUtil;

public class IceryaContainer {
    public Map<String, BeanEntity> internal = new HashMap<String, BeanEntity>();

    IceryaContainer() {
    }

    void addBeanEntity(BeanEntity entity) {
        this.internal.put(entity.getBeanId(), entity);
    }

    protected BeanEntity getBeanEntity(String id) {
        return this.internal.get(id);
    }

    public Object getBean(String id) throws ContainerException {
        if (id == null || id.isEmpty()) {
            throw new ContainerException("Illegal Argument.");
        }
        BeanEntity entity = this.internal.get(id);
        if (entity == null) {
            throw new ContainerException("ID[" + id + "] is not exist.");
        }
        String className = entity.getBeanClass();
        String context = entity.getContext();
        Object result = null;
        Map<String, String> prop = entity.getProperties();
        try {
            if (prop.isEmpty()) {
                result = ReflectionUtil.generate(className);
                if (context != null) {
                    result = ReflectionUtil.convertObject(result, context);
                }
            } else {
                result = ReflectionUtil.generate(className);
                for (String key : prop.keySet()) {
                    Object value = null;
                    value = this.internal.containsKey(prop.get(key)) ? this.getBean(prop.get(key)) : ReflectionUtil.convertObject(result, key, prop.get(key));
                    ReflectionUtil.setProperty(result, key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanCreateException("Bean creation failed.", e);
        }
        return result;
    }
}

