/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.core.BeanCreateException;
import org.arefgard.icerya.container.core.BeanEntity;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.util.ReflectionUtil;

public class IceryaContainer {
    private static final Log log = LogFactory.getLog(IceryaContainer.class);
    public Map<String, BeanEntity> internal = new HashMap<String, BeanEntity>();

    IceryaContainer() {
    }

    void addBeanEntity(BeanEntity entity) {
        this.internal.put(entity.getBeanId(), entity);
    }

    protected BeanEntity getBeanEntity(String id) {
        return this.internal.get(id);
    }

    public Object getBean(String id) throws ContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"---[get bean]---");
        }
        if (id == null || id.isEmpty()) {
            log.error((Object)("Illegal Argument[id=" + id + "]."));
            throw new ContainerException("Illegal Argument.");
        }
        BeanEntity entity = this.internal.get(id);
        if (entity == null) {
            log.error((Object)("ID[" + id + "] is not exitst."));
            throw new ContainerException("ID[" + id + "] is not exist.");
        }
        String className = entity.getBeanClass();
        String context = entity.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("  id = " + id + ", className = " + className));
        }
        Object result = null;
        Map<String, String> prop = entity.getProperties();
        try {
            if (prop.isEmpty()) {
                result = ReflectionUtil.generate(className);
                if (context != null) {
                    result = ReflectionUtil.convertObject(result, context);
                }
            } else {
                result = ReflectionUtil.generate(className);
                for (String key : prop.keySet()) {
                    Object value = null;
                    value = this.internal.containsKey(prop.get(key)) ? this.getBean(prop.get(key)) : ReflectionUtil.convertObject(result, key, prop.get(key));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    property key = " + key + ", value = " + value));
                    }
                    ReflectionUtil.setProperty(result, key, value);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Bean creation failed.", (Throwable)e);
            throw new BeanCreateException("Bean creation failed.", e);
        }
        return result;
    }

    public boolean containsKey(Object key) {
        return this.internal.containsKey(key);
    }
}

