package org.arefgard.icerya.container.core;

import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.util.ReflectionUtil;

/**
 * DIReiB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class IceryaContainer {
	
	/** K[ */
	private static final Log log = LogFactory.getLog(IceryaContainer.class);
	
	/** Rei */
	public Map<String, BeanEntity> internal = new java.util.HashMap<String, BeanEntity>();
	
	/**
	 * ftHgRXgN^B<br/>
	 * <br/>
	 * pbP[Ŵݎg悤ɂB
	 */
	IceryaContainer() {
		
	}
	
	/**
	 * BeanEntityIuWFNgReiɒǉB
	 * @param entity BeanEntityIuWFNg
	 */
	void addBeanEntity(BeanEntity entity) {
		this.internal.put(entity.getBeanId(), entity);
	}
	
	/**
	 * BeanEntityIuWFNgReioB
	 * @param id bean id
	 * @return BeanEntityIuWFNg
	 */
	protected BeanEntity getBeanEntity(String id) {
		return this.internal.get(id);
	}
	
	/**
	 * Bean擾B
	 * @param id Bean ID
	 * @return IuWFNg
	 * @throws ContainerException Bean̐Ɏs
	 */
	public Object getBean(String id) throws ContainerException {
		if(log.isDebugEnabled()) {
			log.debug("---[get bean]---");
		}
		if(id == null || id.isEmpty()) {
			log.error("Illegal Argument[id=" + id + "].");
			throw new ContainerException("Illegal Argument.");
		}
		BeanEntity entity = this.internal.get(id);
		if(entity == null) {
			log.error("ID[" + id + "] is not exitst.");
			throw new ContainerException("ID[" + id + "] is not exist.");
		}
		String className = entity.getBeanClass();
		String context = entity.getContext();
		
		if(log.isDebugEnabled()) {
			log.debug("  id = " + id + ", className = " + className);
		}
		
		Object result = null;
		Map<String, String> prop = entity.getProperties();

		try {
			if (prop.isEmpty()) {
				// propertyȂ
				result = ReflectionUtil.generate(className);
				if(context != null) {
					result = ReflectionUtil.convertObject(result, context);
				}
			} else {
				// property
				result = ReflectionUtil.generate(className);
				for (Iterator<String> itr = prop.keySet().iterator(); itr.hasNext();) {
					String key = itr.next();
					Object value = null;
					if(this.internal.containsKey(prop.get(key))) {
						value = this.getBean(prop.get(key));
					} else {
						value = ReflectionUtil.convertObject(result, key, prop.get(key));
					}
					if(log.isDebugEnabled()) {
						log.debug("    property key = " + key + ", value = " + value);
					}
					ReflectionUtil.setProperty(result, key, value);
				}
			}
		} catch (Exception e) {
			log.error("Bean creation failed.", e);
			throw new BeanCreateException("Bean creation failed.", e);
		}
		
		return result;
	}
	
	public boolean containsKey(Object key) {
		return this.internal.containsKey(key);
	}
}
