/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.core.BeanDefinitionParseException;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.core.IceryaContainer;
import org.arefgard.icerya.container.core.XmlBeanDefinitionReader;

public class ContainerFactory {
    private static final Log log = LogFactory.getLog(ContainerFactory.class);
    private static Map<String, IceryaContainer> cache = new HashMap<String, IceryaContainer>();

    public static synchronized IceryaContainer create(String path) throws ContainerException {
        IceryaContainer result = null;
        if (cache.containsKey(path)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("contaier file [" + path + "] is cached."));
            }
            result = cache.get(path);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("container file [" + path + "] is not cached."));
            }
            try {
                result = new IceryaContainer();
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(result);
                reader.parse(path);
                cache.put(path, result);
            }
            catch (Exception e) {
                log.error((Object)("PATH[" + path + "] is illegal path."), (Throwable)e);
                throw new BeanDefinitionParseException("PATH[" + path + "] is illegal path.", e);
            }
        }
        return result;
    }

    public static synchronized IceryaContainer create() throws ContainerException {
        return new IceryaContainer();
    }
}

