package org.arefgard.icerya.container.core;

import org.arefgard.icerya.container.core.def.BeanDef;
import org.arefgard.icerya.container.core.def.PropertyDef;
import org.arefgard.icerya.container.core.def.ValueResourceDef;
import org.arefgard.icerya.container.strategy.cache.impl.NoneCacheStrategy;
import org.arefgard.icerya.container.strategy.cache.impl.SingletonCacheStrategy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * Beanp[X邽߂ContentHandlerB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class BeanHandler implements ContentHandler {
	
	private static final String NODE_BEAN = "bean";
	private static final String NODE_PROPERTY = "property";
	private static final String ATTR_ID = "id";
	private static final String ATTR_CLASS = "class";
	private static final String ATTR_CACHE = "cache";
	private static final String ATTR_INIT_METHOD = "init-method";
	private static final String ATTR_DESTROY_METHOD = "destroy-method";
	private static final String ATTR_NAME = "name";
	private static final String NODE_INCLUDE = "include";
	private static final String ATTR_REF = "ref";
	
	private String nowBean;
	private String nowProperty;
	private IceryaContainer container;
	
	public BeanHandler(IceryaContainer container) {
		this.container = container;
	}
	
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		String text = new String(ch, start, length).trim();
		if(nowBean != null && nowProperty == null && !text.equals("")) {
			BeanDef now = this.container.getBeanDef(nowBean);
			now.setContext(text);
		}else if(nowBean != null && nowProperty != null) {
			BeanDef now = this.container.getBeanDef(nowBean);
			PropertyDef propertyDef = now.getProperty(nowProperty);
			// UAValueResourceDefƂēo^Ă
			ValueResourceDef resourceDef = new ValueResourceDef();
			resourceDef.setValue(text);
			propertyDef.setResourceDef(resourceDef);
			now.addProperty(nowProperty, propertyDef);
		}
	}

	public void endDocument() throws SAXException {

	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if(qName.endsWith(NODE_BEAN)) {
			// <bean>
			this.nowBean = null;
		}else if(qName.endsWith(NODE_PROPERTY)) {
			// <property>
			this.nowProperty = null;
		}
	}

	public void endPrefixMapping(String prefix) throws SAXException {

	}

	public void ignorableWhitespace(char[] ch, int start, int length)
			throws SAXException {

	}

	public void processingInstruction(String target, String data)
			throws SAXException {

	}

	public void setDocumentLocator(Locator locator) {

	}

	public void skippedEntity(String name) throws SAXException {

	}

	public void startDocument() throws SAXException {

	}

	public void startElement(String uri, String localName, String qName,
			Attributes atts) throws SAXException {
		if(qName.endsWith(NODE_BEAN)) {
			// <bean>
			BeanDef beanDef = new BeanDef();
			
			// id̎擾
			String id = atts.getValue(ATTR_ID);
			if(id == null || id.equals("")) {
				throw new SAXException("bean tag's id attribute is reqired.");
			}
			if(this.container.containsBean(id)) {
				throw new SAXException("bean tag's id attribute is duplicated.");
			}
			beanDef.setBeanId(id);
			// class̎擾
			String clsStr = atts.getValue(ATTR_CLASS);
			if(clsStr == null || clsStr.equals("")) {
				throw new SAXException("bean tag's class attribute is required.");
			}
			Class cls = null;
			try {
				cls = Class.forName(clsStr);
			}catch(ClassNotFoundException e) {
				throw new SAXException("Class[" + clsStr + "] is not found.");
			}
			beanDef.setBeanClass(cls);
			// cache̎擾
			String cacheStr = atts.getValue(ATTR_CACHE);
			if(cacheStr == null || cacheStr.equals("") || cacheStr.equals("none")) {
				beanDef.setCacheStrategy(new NoneCacheStrategy());
			}else if(cacheStr.equals("singleton")) {
				beanDef.setCacheStrategy(new SingletonCacheStrategy());
				// singletonw肵ꍇ́Ainit-methodAdestroy-method擾
				// init-method̎擾
				String initMethod = atts.getValue(ATTR_INIT_METHOD);
				beanDef.setInitMethod(initMethod);
				// destroy-method̎擾
				String destroyMethod = atts.getValue(ATTR_DESTROY_METHOD);
				beanDef.setDestroyMethod(destroyMethod);
			}else {
				throw new SAXException(cacheStr + " is not supported.");
			}
			this.nowBean = beanDef.getBeanId();
			this.container.addBeanDef(beanDef);
		}else if(qName.endsWith(NODE_PROPERTY)) {
			// <property>
			String name = atts.getValue(ATTR_NAME);
			if(name == null || name.equals("")) {
				throw new SAXException("property tag's name attribute is required.");
			}
			BeanDef beanDef = container.getBeanDef(nowBean);
			PropertyDef propertyDef = new PropertyDef();
			propertyDef.setKey(name);
			beanDef.addProperty(name, propertyDef);
			this.nowProperty = name;
		}else if(qName.endsWith(NODE_INCLUDE)) {
			// <include>
			String ref = atts.getValue(ATTR_REF);
			if(ref == null || ref.equals("")) {
				throw new SAXException("include tag's ref attribute is required.");
			}
			try {
				IceryaContainer includeContainer = ContainerFactory.create(ref);
				this.container.addContainer(includeContainer);
			}catch(Exception e) {
				throw new SAXException("error occurred while parsing " + ref, e);
			}
		}
	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {

	}

}
