package org.arefgard.icerya.container.core;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DIRei쐬t@NgB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class ContainerFactory {
	
	/** K[ */
	private static final Log log = LogFactory.getLog(ContainerFactory.class);
	
	/** ReiLbV */
	private static Map<String, IceryaContainer> cache = new java.util.HashMap<String, IceryaContainer>();
	
	/**
	 * @DIRei𐶐B
	 * <br/>
	 * <br/>
	 * @w肵DIReiɐς݂ł΁ALbV炻̃Rei擾
	 * B܂ĂȂ΁AVKɐLbVɕۑĂB
	 * 
	 * @param path DIReipX
	 * @return DIRei
	 * @throws ContainerException DIRei̐Ɏsꍇ
	 */
	public synchronized static IceryaContainer create(String path) throws ContainerException {
		
		IceryaContainer result = null;
		if(cache.containsKey(path)) {
			// LbVĂ
			if(log.isDebugEnabled()) {
				log.debug("contaier file [" + path +  "] is cached.");
			}
			result = cache.get(path);
		}else {
			// ReiVK쐬
			if(log.isDebugEnabled()) {
				log.debug("container file [" + path + "] is not cached.");
			}
			try {
				result = new IceryaContainer();
				XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(result);
				reader.parse(path);
				cache.put(path, result);
			}catch(Exception e) {
				log.error("PATH[" + path + "] is illegal path.", e);
				throw new BeanDefinitionParseException("PATH[" + path + "] is illegal path.", e);
			}
		}
		return result;
	}
	
	/**
	 * DIRei𐶐B
	 * <br/>
	 * <br/>
	 * @LbVȂ̃Rei𐶐BLbVKvł΁Ap
	 * ŃLbVsB
	 * @return DIRei
	 * @throws ContainerException DIRei̐Ɏsꍇ
	 */
	public synchronized static IceryaContainer create() throws ContainerException {
		return new IceryaContainer();
	}
}
