package org.arefgard.icerya.container.core;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.arefgard.icerya.container.core.def.BeanDef;
import org.arefgard.icerya.container.core.def.PropertyDef;
import org.arefgard.icerya.container.core.def.ReferenceResourceDef;
import org.arefgard.icerya.container.core.def.ValueResourceDef;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * XMLŒ`ꂽBean`t@Cp[XB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class XmlBeanDefinitionReader {
	
	/** p[Xi[DIRei */
	private IceryaContainer container;
	
	/**
	 * RXgN^B
	 * 
	 * @param container p[Xi[DIRei
	 */
	public XmlBeanDefinitionReader(IceryaContainer container) {
		this.container = container;
	}
	
	/**
	 * Bean`t@Cp[XB
	 * 
	 * @param path Bean`t@C̃pX
	 * @throws ContainerException Bean`t@C̃p[XɎsꍇ
	 */
	public void parse(String path) throws ContainerException {
		
		
		InputStream is = null;
		ByteArrayOutputStream os = null;
		String head = null;
		try {
			is = ClassLoader.getSystemResourceAsStream(path);
			if(is == null) {
				path.getClass().getClassLoader().getResourceAsStream(path);
			}
			os = new ByteArrayOutputStream();
			int len = 0;
			byte[] buf = new byte[4096];
			len = is.read(buf);
			os.write(buf, 0, len);
			head = os.toString();
		}catch(Exception e) {
			throw new BeanDefinitionParseException(e);
		}finally {
			if(is != null) {
				try {
					is.close();
				}catch(Exception e) {
					// ignore
				}
			}
			if(os != null) {
				try {
					os.close();
				}catch(Exception e) {
					// ignore
				}
			}
		}
		// 擪͂
		if(head == null) {
			throw new BeanDefinitionParseException();
		}else if(head.indexOf("<container") > 0) {
			// IceryaContainer
		}else {
			throw new BeanDefinitionParseException();
		}
		
		
		// SAXp[T̎擾
		XMLReader reader = null;
		try {
			reader = XMLReaderFactory.createXMLReader();
		} catch (SAXException e) {
			throw new BeanDefinitionParseException("Creation XMLReader failed.", e);
		}
		
		// nh̐ݒ
		reader.setContentHandler(new BeanHandler(container));
		is = ClassLoader.getSystemResourceAsStream(path);
		if(is == null) {
			is = this.getClass().getClassLoader().getResourceAsStream(path);
		}

		try {
			reader.parse(new InputSource(is));
		} catch (FileNotFoundException e) {
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		} catch (IOException e) {
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		} catch (SAXException e) {
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		}finally {
			try {
				if(is != null) {
					is.close();
				}
			}catch(Exception ignored) {}
		}
		
		// ResourceDef̉
		Map<String, BeanDef> beanMap = container.getAllBeanDef();
		Set<String> keys1 = beanMap.keySet();
		for(Iterator<String> itr1 = keys1.iterator(); itr1.hasNext();) {
			String key1 = itr1.next();
			BeanDef beanDef = beanMap.get(key1);
			
			// Propertỷ
			Map<String, PropertyDef> properties = beanDef.getProperties();
			Set<String> keys2 = properties.keySet();
			for(Iterator<String> itr2 = keys2.iterator(); itr2.hasNext();) {
				String key2 = itr2.next();
				PropertyDef propertyDef = beanDef.getProperty(key2);
				if(beanMap.containsKey(key2)) {
					// QƂĂꍇ́AReferenceResourceDefɒu
					ReferenceResourceDef refDef = new ReferenceResourceDef((String)((ValueResourceDef)propertyDef.getResourceDef()).getValue());
					propertyDef.setResourceDef(refDef);
					propertyDef.setType(container.getBean(refDef.getRef()).getClass());
				}else {
					// QƂĂȂꍇ́AValueResourceDefƂĐ^ŕۑ
					ValueResourceDef resourceDef = (ValueResourceDef)propertyDef.getResourceDef();
					Class cls = beanDef.getBeanClass();
					String type = null;
					Field[] fields = cls.getDeclaredFields();
					int len = fields.length;
					for(int i = 0; i < len; i++) {
						if(fields[i].getName().equals(key2)) {
							propertyDef.setType(fields[i].getType());
							type = fields[i].getType().getName();
							break;
						}
					}
					String value = (String)resourceDef.getValue();
					if(value.startsWith("\"") && value.endsWith("\"")) {
						resourceDef.setValue(value.substring(1, value.length() -1));
					}else if(type.equals("byte") || type.equals("java.lang.Byte")) {
						resourceDef.setValue(new Byte(value));
					}else if(type.equals("short") || type.equals("java.lang.Short")) {
						resourceDef.setValue(new Short(value));
					}else if(type.equals("int") || type.equals("java.lang.Integer")) {
						resourceDef.setValue(new Integer(value));
					}else if(type.equals("long") || type.equals("java.lang.Long")) {
						resourceDef.setValue(new Long(value));
					}else if(type.equals("float") || type.equals("java.lang.Float")) {
						resourceDef.setValue(new Float(value));
					}else if(type.equals("double") || type.equals("java.lang.Double")) {
						resourceDef.setValue(new Double(value));
					}else if(type.equals("char") || type.equals("java.lang.Character")) {
						resourceDef.setValue(new Character(value.toCharArray()[0]));
					}
					
				}
			}
		}
		
	}
}
