package org.arefgard.icerya.container.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Date;

import org.arefgard.icerya.example.model.Customer;
import org.arefgard.icerya.example.model.Object01;
import org.arefgard.icerya.example.model.Object02;
import org.arefgard.icerya.example.model.Person;
import org.junit.Test;

public class IceryaContainerTest {
	
	/**
	 * R|[lg`t@Cp[XāÃIuWFNg𐶐ł
	 * ƂmFB
	 */
	@Test
	public void getSimpleBean() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container01.xml");
			Date date = (Date)container.getBean("now");
			assertNotNull(date);
			String userId = (String)container.getBean("userId");
			assertNotNull(userId);
			assertEquals("", userId);
			String password = (String)container.getBean("userId");
			assertNotNull(password);
			assertEquals("", password);
		}catch(ContainerException e) {
			fail("" + e);
		}
	}
	
	@Test
	public void getBeanWithProperty() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container02.xml");
			Customer customer = (Customer)container.getBean("customer");
			assertEquals("0001", customer.getCustomerId());
			assertEquals("Yamada", customer.getFirstName());
			assertEquals("Taro", customer.getLastName());
			assertEquals(1, customer.getAge());
		}catch(ContainerException e) {
			fail("" + e);
		}
	}
	
	@Test
	public void getBeanWithRefProperty() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container03.xml");
			Person person = (Person)container.getBean("person");
			assertEquals("Yamada", person.getFullName().getFirstName());
			assertEquals("Taro", person.getFullName().getLastName());
			assertEquals(1, person.getAge());
		}catch(ContainerException e) {
			fail("" + e);
		}
	}
	
	@Test
	public void getBeanWithContext() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container04.xml");
			String str1 = (String)container.getBean("str1");
			assertEquals("Strings", str1);
		}catch(ContainerException e) {
			fail("" + e);
		}
	}
	
	@Test
	public void getBeanUsingInitMethodAndDestroyMethod() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container05.xml");
			Object01 obj = (Object01)container.getBean("obj01");
			assertEquals("INIT", obj.getField01());
		}catch(ContainerException e) {
			e.printStackTrace();
			fail("" + e);
		}
	}
	
	@Test
	public void getBeanInIncludedContainer() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container05.xml");
			Object02 obj = (Object02)container.getBean("obj02");
			assertEquals("hoge", obj.getField01());
		}catch(ContainerException e) {
			e.printStackTrace();
			fail("" + e);
		}
	}
	
	@Test
	public void setNullID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container03.xml");
			container.getBean(null);
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("");
		}
	}
	
	@Test
	public void setEmptyID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container03.xml");
			container.getBean("");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("" + e);
		}
	}
	
	@Test
	public void setNotExistsID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/core/container03.xml");
			container.getBean("hoge");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("" + e);
		}
	}
	
	@Test
	public void setIllegalPath() {
		try {
			IceryaContainer container = ContainerFactory.create("notfound");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("");
		}
	}
	
}
