/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.adempiere.pipo2.IDFinder;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackInHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.xml.sax.helpers.DefaultHandler;

public class PackIn {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_UpdateDictionary = false;
    private String m_packageDirectory = null;
    private Map<String, Integer> tableCache = new HashMap<String, Integer>();
    private Map<String, Integer> columnCache = new HashMap<String, Integer>();
    private String packageName = null;
    private String packageVersion = null;
    private List<X_AD_Package_Imp_Detail> importDetails;

    public void addTable(String tableName, int tableId) {
        this.tableCache.put(tableName, tableId);
    }

    public int getTableId(String tableName) {
        if (this.tableCache.containsKey(tableName)) {
            return this.tableCache.get(tableName);
        }
        return 0;
    }

    public void addColumn(String tableName, String columnName, int columnId) {
        this.columnCache.put(String.valueOf(tableName) + "." + columnName, columnId);
    }

    public int getColumnId(String tableName, String columnName) {
        String key = String.valueOf(tableName) + "." + columnName;
        if (this.columnCache.containsKey(key)) {
            return this.columnCache.get(key);
        }
        return 0;
    }

    public String importXML(String fileName, Properties ctx, String trxName) throws Exception {
        File in;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("importXML:" + fileName);
        }
        if (!(in = new File(fileName)).exists()) {
            String msg = "File does not exist: " + fileName;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("importXML:" + msg);
            }
            return msg;
        }
        try {
            FileInputStream input = new FileInputStream(in);
            return this.importXML(input, ctx, trxName);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importXML:", (Throwable)e);
            throw e;
        }
    }

    public void addImportDetail(X_AD_Package_Imp_Detail importDetail) {
        this.importDetails.add(importDetail);
    }

    public String importXML(InputStream input, Properties ctx, String trxName) {
        try {
            this.log.info("starting");
            IDFinder.clearIDCache();
            this.importDetails = new ArrayList<X_AD_Package_Imp_Detail>();
            PackInHandler handler = new PackInHandler();
            PIPOContext context = new PIPOContext();
            context.trx = Trx.get((String)trxName, (boolean)true);
            context.packIn = this;
            context.ctx = ctx;
            handler.setCtx(context);
            handler.setProcess(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            String msg = "Start Parser";
            this.log.info(msg);
            parser.parse(input, (DefaultHandler)handler);
            for (PO pO : this.importDetails) {
                pO.saveEx();
            }
            msg = "End Parser";
            this.log.info(msg);
            if (handler.getUnresolvedCount() > 0) {
                handler.dumpUnresolvedElements();
            }
            return "Processed=" + handler.getElementsProcessed() + " Un-Resolved=" + handler.getUnresolvedCount();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importXML:", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String getPackageDirectory() {
        return this.m_packageDirectory;
    }

    public void setPackageDirectory(String packageDirectory) {
        this.m_packageDirectory = packageDirectory;
    }

    public boolean isUpdateDictionary() {
        return this.m_UpdateDictionary;
    }

    public void setUpdateDictionary(boolean updateDictionary) {
        this.m_UpdateDictionary = updateDictionary;
    }

    public byte[] readBlob(String fileName) throws IOException {
        byte[] data = null;
        File file = new File(String.valueOf(this.m_packageDirectory) + File.separator + "blobs" + File.separator, fileName);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
            data = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
                bis = null;
            }
        }
        return data;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }
}

