/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.ReferenceUtils;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PoExporter {
    private PO po = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private PIPOContext ctx;
    private TransformerHandler transformerHandler;

    private void addTextElement(String qName, String text, AttributesImpl atts) {
        try {
            this.transformerHandler.startElement("", "", qName, atts);
            this.append(text);
            this.transformerHandler.endElement("", "", qName);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void append(String str) throws SAXException {
        char[] contents = str != null ? str.toCharArray() : new char[]{};
        this.transformerHandler.characters(contents, 0, contents.length);
    }

    public PoExporter(PIPOContext ctx, TransformerHandler handler, PO po) {
        this.ctx = ctx;
        this.po = po;
        this.transformerHandler = handler;
    }

    public void addUnchecked(String name, String value, AttributesImpl atts) {
        this.addTextElement(name, value, atts);
    }

    public void addString(String name, String stringValue, AttributesImpl atts) {
        this.addString(name, stringValue, "", atts);
    }

    public void addString(String name, String stringValue, String defaultValue, AttributesImpl atts) {
        this.addTextElement(name, stringValue != null ? stringValue : defaultValue, atts);
    }

    public void addBoolean(String name, boolean boolValue, AttributesImpl atts) {
        this.addTextElement(name, boolValue ? "true" : "false", atts);
    }

    public void add(String columnName, AttributesImpl atts) {
        this.add(columnName, "", atts);
    }

    public void add(String columnName, String defaultValue, AttributesImpl atts) {
        Object value = this.po.get_Value(columnName);
        if (value == null) {
            this.addTextElement(columnName, defaultValue, atts);
            return;
        }
        if (value instanceof String) {
            this.addTextElement(columnName, (String)value, atts);
        } else if (value instanceof Boolean) {
            this.addTextElement(columnName, (Boolean)value != false ? "true" : "false", atts);
        } else if (value instanceof Integer) {
            this.addTextElement(columnName, value.toString(), atts);
        } else if (value instanceof BigDecimal) {
            this.addTextElement(columnName, value.toString(), atts);
        } else {
            this.addTextElement(columnName, value.toString(), atts);
        }
    }

    public void add(String columnName, boolean defaultValue, AttributesImpl atts) {
        Object oo = this.po.get_Value(columnName);
        boolean value = defaultValue;
        if (oo != null) {
            value = oo instanceof Boolean ? ((Boolean)oo).booleanValue() : "Y".equals(oo);
        }
        this.addBoolean(columnName, value, atts);
    }

    public void addIsActive(AttributesImpl atts) {
        this.addTextElement("IsActive", Boolean.valueOf(this.po.isActive()) != false ? "true" : "false", atts);
    }

    public void addTableReference(String tableName, String searchColumn, AttributesImpl atts) {
        String columnName = String.valueOf(tableName) + "_ID";
        this.addTableReference(columnName, tableName, searchColumn, atts);
    }

    public void addTableReference(String columnName, String tableName, String searchColumn, AttributesImpl atts) {
        int id = this.po.get_Value(columnName) != null ? (Integer)this.po.get_Value(columnName) : 0;
        this.addTableReference(columnName, tableName, searchColumn, id, atts);
    }

    public void addTableReference(String columnName, String tableName, String searchColumn, int id, AttributesImpl atts) {
        String value = ReferenceUtils.getTableReference(tableName, searchColumn, id, atts);
        this.addString(columnName, value, atts);
    }

    public void export(List<String> excludes) {
        this.export(excludes, false);
    }

    public void export(List<String> excludes, boolean preservedOrg) {
        POInfo info = POInfo.getPOInfo((Properties)this.po.getCtx(), (int)this.po.get_Table_ID());
        int count = info.getColumnCount();
        int AD_Client_ID = this.po.getAD_Client_ID();
        if (AD_Client_ID == 0) {
            this.addString("AD_Client_ID", "0", new AttributesImpl());
            if (excludes == null || !excludes.contains("AD_Org_ID")) {
                this.addString("AD_Org_ID", "0", new AttributesImpl());
            }
        } else if (excludes == null || !excludes.contains("AD_Org_ID")) {
            int AD_Org_ID = this.po.getAD_Org_ID();
            if (AD_Org_ID == 0) {
                this.addString("AD_Org_ID", "0", new AttributesImpl());
            } else if (!preservedOrg) {
                this.addString("AD_Org_ID", "@AD_Org_ID@", new AttributesImpl());
            } else {
                this.addTableReference("AD_Client", "Value", new AttributesImpl());
                this.addTableReference("AD_Org", "Value", new AttributesImpl());
            }
        }
        int i = 0;
        while (i < count) {
            block55: {
                int AD_Table_ID;
                int displayType;
                String columnName;
                block54: {
                    columnName = info.getColumnName(i);
                    if (excludes == null) break block54;
                    boolean exclude = false;
                    for (String ex : excludes) {
                        if (!ex.equalsIgnoreCase(columnName)) continue;
                        exclude = true;
                        break;
                    }
                    if (exclude) break block55;
                }
                if (20 == (displayType = info.getColumnDisplayType(i))) {
                    this.add(columnName, false, new AttributesImpl());
                } else if (19 == displayType || 13 == displayType) {
                    int AD_Tree_ID;
                    String tableName = null;
                    String searchColumn = null;
                    if ("Record_ID".equalsIgnoreCase(columnName) && this.po.get_ColumnIndex("AD_Table_ID") >= 0) {
                        AD_Table_ID = this.po.get_Value(this.po.get_ColumnIndex("AD_Table_ID")) != null ? (Integer)this.po.get_Value(this.po.get_ColumnIndex("AD_Table_ID")) : 0;
                        tableName = MTable.getTableName((Properties)this.ctx.ctx, (int)AD_Table_ID);
                        searchColumn = String.valueOf(tableName) + "_ID";
                    } else if (this.po.get_TableName().equals("AD_TreeNode") && columnName.equals("Parent_ID")) {
                        AD_Tree_ID = this.po.get_ValueAsInt("AD_Tree_ID");
                        int AD_Table_ID2 = DB.getSQLValue((String)this.po.get_TrxName(), (String)("SELECT AD_Table_ID From AD_Tree WHERE AD_Tree_ID=" + AD_Tree_ID));
                        tableName = MTable.getTableName((Properties)this.po.getCtx(), (int)AD_Table_ID2);
                        searchColumn = String.valueOf(tableName) + "_ID";
                    } else if (this.po.get_TableName().equals("AD_TreeNode") && columnName.equals("Node_ID")) {
                        AD_Tree_ID = this.po.get_ValueAsInt("AD_Tree_ID");
                        int AD_Table_ID3 = DB.getSQLValue((String)this.po.get_TrxName(), (String)("SELECT AD_Table_ID From AD_Tree WHERE AD_Tree_ID=" + AD_Tree_ID));
                        tableName = MTable.getTableName((Properties)this.po.getCtx(), (int)AD_Table_ID3);
                        searchColumn = String.valueOf(tableName) + "_ID";
                    } else {
                        searchColumn = columnName;
                        tableName = columnName.substring(0, columnName.length() - 3);
                        if (tableName.equalsIgnoreCase("ad_table")) {
                            searchColumn = "TableName";
                        } else if (tableName.equalsIgnoreCase("ad_column") || tableName.equalsIgnoreCase("ad_element")) {
                            searchColumn = "ColumnName";
                        }
                    }
                    if (searchColumn.endsWith("_ID")) {
                        AD_Table_ID = MTable.getTable_ID((String)tableName);
                        POInfo pInfo = POInfo.getPOInfo((Properties)this.po.getCtx(), (int)AD_Table_ID);
                        if (pInfo.getColumnIndex("Value") >= 0) {
                            searchColumn = "Value";
                        } else if (pInfo.getColumnIndex("Name") >= 0) {
                            searchColumn = "Name";
                        } else if (pInfo.getColumnIndex("DocumentNo") >= 0) {
                            searchColumn = "DocumentNo";
                        }
                    }
                    this.addTableReference(columnName, tableName, searchColumn, new AttributesImpl());
                } else if (17 == displayType) {
                    this.add(columnName, "", new AttributesImpl());
                } else if (DisplayType.isLookup((int)displayType)) {
                    String searchColumn = null;
                    String tableName = null;
                    if ("Record_ID".equalsIgnoreCase(columnName) && this.po.get_ColumnIndex("AD_Table_ID") >= 0) {
                        AD_Table_ID = this.po.get_Value(this.po.get_ColumnIndex("AD_Table_ID")) != null ? (Integer)this.po.get_Value(this.po.get_ColumnIndex("AD_Table_ID")) : 0;
                        tableName = MTable.getTableName((Properties)this.ctx.ctx, (int)AD_Table_ID);
                        searchColumn = String.valueOf(tableName) + "_ID";
                    } else if (info.getColumnLookup(i) != null) {
                        searchColumn = info.getColumnLookup(i).getColumnName();
                        tableName = searchColumn.substring(0, searchColumn.indexOf("."));
                        searchColumn = searchColumn.substring(searchColumn.indexOf(".") + 1);
                    } else {
                        searchColumn = columnName;
                    }
                    if (searchColumn.endsWith("_ID")) {
                        if (tableName.equalsIgnoreCase("ad_table")) {
                            searchColumn = "TableName";
                        } else if (tableName.equalsIgnoreCase("ad_column") || tableName.equalsIgnoreCase("ad_element")) {
                            searchColumn = "ColumnName";
                        } else {
                            AD_Table_ID = MTable.getTable_ID((String)tableName);
                            POInfo pInfo = POInfo.getPOInfo((Properties)this.po.getCtx(), (int)AD_Table_ID);
                            if (pInfo.getColumnIndex("Value") >= 0) {
                                searchColumn = "Value";
                            } else if (pInfo.getColumnIndex("Name") >= 0) {
                                searchColumn = "Name";
                            } else if (pInfo.getColumnIndex("DocumentNo") >= 0) {
                                searchColumn = "DocumentNo";
                            }
                        }
                    }
                    this.addTableReference(columnName, tableName, searchColumn, new AttributesImpl());
                } else if (DisplayType.isLOB((int)displayType)) {
                    this.addBlob(columnName);
                } else if (!columnName.equals(this.po.getUUIDColumnName()) || this.po.get_Value(columnName) != null) {
                    this.add(columnName, "", new AttributesImpl());
                }
            }
            ++i;
        }
    }

    public void addBlob(String columnName) {
        Object value = this.po.get_Value(columnName);
        if (value == null) {
            this.addString(columnName, "", new AttributesImpl());
            return;
        }
        PackOut packOut = this.ctx.packOut;
        byte[] data = null;
        String dataType = null;
        String fileName = null;
        try {
            if (value instanceof String) {
                data = ((String)value).getBytes("UTF-8");
                dataType = "string";
            } else {
                data = (byte[])value;
                dataType = "byte[]";
            }
            fileName = packOut.writeBlob(data);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.addString(columnName, String.valueOf(fileName) + "|" + dataType, new AttributesImpl());
    }
}

