/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.ProcessParaElementHandler;
import org.compiere.model.MAttachment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Process;
import org.compiere.model.X_AD_Process_Para;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProcessElementHandler
extends AbstractElementHandler {
    private ProcessParaElementHandler paraHandler = new ProcessParaElementHandler();
    private List<Integer> processes = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes;
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_Process mProcess = (X_AD_Process)this.findPO(ctx, element);
        if (mProcess == null) {
            String value = this.getStringValue(element, "Value");
            int id = this.findIdByColumn(ctx, "AD_Process", "Value", value);
            mProcess = new X_AD_Process(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
        }
        if (mProcess.getAD_Process_ID() == 0 && this.isOfficialId(element, "AD_Process_ID")) {
            mProcess.setAD_Process_ID(Integer.parseInt(this.getStringValue(element, "AD_Process_ID")));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mProcess, element, (AbstractElementHandler)this)).autoFill(excludes = this.defaultExcludeList("AD_Process"))).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mProcess.is_new()) {
            if (!mProcess.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Process", 284);
        String action = null;
        if (!mProcess.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Process", (PO)mProcess);
            action = "Update";
        } else {
            action = "New";
        }
        if (mProcess.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mProcess.getName(), mProcess.get_ID(), action);
            element.recordId = mProcess.getAD_Process_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mProcess.getName(), mProcess.get_ID(), action);
        throw new POSaveFailedException("Failed to save Process " + mProcess.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Process_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Process_ID");
        if (this.processes.contains(AD_Process_ID)) {
            return;
        }
        this.processes.add(AD_Process_ID);
        PackOut packOut = ctx.packOut;
        X_AD_Process m_Process = new X_AD_Process(ctx.ctx, AD_Process_ID, this.getTrxName(ctx));
        AttributesImpl atts = new AttributesImpl();
        try {
            ElementHandler handler;
            MAttachment attachment = m_Process.getAttachment();
            if (attachment != null && attachment.get_ID() > 0) {
                handler = ctx.packOut.getHandler("AD_Attachment");
                try {
                    handler.packOut(ctx.packOut, document, null, attachment.getAD_Attachment_ID());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (m_Process.isReport() && m_Process.getAD_ReportView_ID() > 0) {
                handler = packOut.getHandler("AD_ReportView");
                handler.packOut(packOut, document, null, m_Process.getAD_ReportView_ID());
            }
            if (m_Process.isReport() && m_Process.getAD_PrintFormat_ID() > 0) {
                handler = packOut.getHandler("AD_PrintFormat");
                handler.packOut(packOut, document, null, m_Process.getAD_PrintFormat_ID());
            }
            if (m_Process.getAD_Workflow_ID() > 0) {
                handler = packOut.getHandler("AD_Workflow");
                handler.packOut(packOut, document, null, m_Process.getAD_Workflow_ID());
            }
            boolean createElement = true;
            if (ctx.packOut.getFromDate() != null && m_Process.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                createElement = false;
            }
            if (createElement) {
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Process", atts);
                this.createProcessBinding(ctx, document, m_Process);
            }
            Query query = new Query(ctx.ctx, "AD_Process_PARA", "AD_Process_ID = ?", this.getTrxName(ctx));
            List paralist = query.setParameters(new Object[]{AD_Process_ID}).list();
            for (X_AD_Process_Para para : paralist) {
                ElementHandler handler2;
                if (para.getAD_Reference_ID() > 0) {
                    handler2 = packOut.getHandler("AD_Reference");
                    handler2.packOut(packOut, document, null, para.getAD_Reference_ID());
                }
                if (para.getAD_Reference_Value_ID() > 0) {
                    handler2 = packOut.getHandler("AD_Reference");
                    handler2.packOut(packOut, document, null, para.getAD_Reference_Value_ID());
                }
                if (para.getAD_Val_Rule_ID() > 0) {
                    handler2 = packOut.getHandler("AD_Val_Rule");
                    handler2.packOut(packOut, document, null, para.getAD_Val_Rule_ID());
                }
                this.createProcessPara(ctx, document, para.getAD_Process_Para_ID());
            }
            if (createElement) {
                document.endElement("", "", "AD_Process");
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private void createProcessPara(PIPOContext ctx, TransformerHandler document, int AD_Process_Para_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Process_Para_ID", (int)AD_Process_Para_ID);
        this.paraHandler.create(ctx, document);
        ctx.ctx.remove("AD_Process_Para_ID");
    }

    private void createProcessBinding(PIPOContext ctx, TransformerHandler document, X_AD_Process m_Process) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Process);
        List excludes = this.defaultExcludeList("AD_Process");
        if (m_Process.getAD_Process_ID() <= 999999) {
            filler.add("AD_Process_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Process_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Process_ID");
    }
}

