/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SQLStatementElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        block22: {
            String elementValue = element.getElementValue();
            this.log.info(elementValue);
            String DBType = this.getStringValue(element, "DBType");
            String sql = this.getStringValue(element, "statement");
            if (sql.endsWith(";") && !sql.toLowerCase().endsWith("end;")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                    if (DBType.equals("ALL")) {
                        int n = pstmt.executeUpdate();
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("Executed SQL Statement: " + this.getStringValue(element, "statement") + " ReturnValue=" + n);
                        }
                    } else if (DB.isOracle() && DBType.equals("Oracle")) {
                        int n = pstmt.executeUpdate();
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("Executed SQL Statement for Oracle: " + this.getStringValue(element, "statement") + " ReturnValue=" + n);
                        }
                    } else if (DB.isPostgreSQL() && (DBType.equals("Postgres") || DBType.equals("PostgreSQL"))) {
                        Statement stmt = null;
                        try {
                            stmt = pstmt.getConnection().createStatement();
                            int n = stmt.executeUpdate(sql);
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info("Executed SQL Statement for PostgreSQL: " + this.getStringValue(element, "statement") + " ReturnValue=" + n);
                            }
                        }
                        finally {
                            DB.close((Statement)stmt);
                            stmt = null;
                        }
                    }
                    X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "", 0);
                    this.logImportDetail(ctx, impDetail, 1, "SQLStatement", 1, "Execute");
                }
                catch (Exception e) {
                    if (DB.isPostgreSQL() && pstmt != null) {
                        Connection m_con = null;
                        try {
                            m_con = pstmt.getConnection();
                            if (m_con != null && !m_con.getAutoCommit()) {
                                m_con.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    this.log.log(Level.SEVERE, "SQLSatement", (Throwable)e);
                    X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "", 0);
                    this.logImportDetail(ctx, impDetail, 0, "SQLStatement", 1, "Execute");
                    DB.close((Statement)pstmt);
                    pstmt = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                pstmt = null;
                throw throwable;
            }
            DB.close((Statement)pstmt);
            pstmt = null;
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String SQLStatement = Env.getContext((Properties)ctx.ctx, (String)"SQLStatement");
        String DBType = Env.getContext((Properties)ctx.ctx, (String)"DBType");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        document.startElement("", "", "SQLStatement", atts);
        this.createSQLStatmentBinding(document, SQLStatement, DBType);
        document.endElement("", "", "SQLStatement");
    }

    private void createSQLStatmentBinding(TransformerHandler document, String sqlStatement, String DBType) throws SAXException {
        document.startElement("", "", "DBType", new AttributesImpl());
        char[] contents = DBType.toCharArray();
        document.characters(contents, 0, contents.length);
        document.endElement("", "", "DBType");
        document.startElement("", "", "statement", new AttributesImpl());
        contents = sqlStatement.toCharArray();
        document.startCDATA();
        document.characters(contents, 0, contents.length);
        document.endCDATA();
        document.endElement("", "", "statement");
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int field) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        Env.setContext((Properties)packout.getCtx().ctx, (String)"SQLStatement", (String)((String)detail.getProperty("SQLStatement")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"DBType", (String)((String)detail.getProperty("DBType")));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("SQLStatement");
        packout.getCtx().ctx.remove("DBType");
    }
}

