/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.FieldElementHandler;
import org.compiere.model.MTab;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TabElementHandler
extends AbstractElementHandler {
    private FieldElementHandler fieldHandler = new FieldElementHandler();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes = this.defaultExcludeList("AD_Tab");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (this.isParentDefer(element, "AD_Window")) {
            element.defer = true;
            return;
        }
        MTab mTab = (MTab)this.findPO(ctx, element);
        if (mTab == null) {
            String name = this.getStringValue(element, "Name", excludes);
            int windowId = 0;
            if (this.getParentId(element, "AD_Window") > 0) {
                windowId = this.getParentId(element, "AD_Window");
            } else {
                Element windowElement = (Element)element.properties.get("AD_Window_ID");
                windowId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)windowElement, (String)this.getTrxName(ctx));
            }
            if (windowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Window_ID";
                return;
            }
            Element tableElement = (Element)element.properties.get("AD_Table_ID");
            int tableId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)tableElement, (String)this.getTrxName(ctx));
            if (tableId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Table_ID";
                return;
            }
            String sql = "SELECT AD_Tab_ID FROM AD_Tab where AD_Window_ID = ?  AND Name = ? AND AD_Table_ID = ?";
            int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)sql, (Object[])new Object[]{windowId, name, tableId});
            mTab = new MTab(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            mTab.setAD_Table_ID(tableId);
            mTab.setName(name);
            mTab.setAD_Window_ID(windowId);
        }
        PoFiller filler = new PoFiller(ctx, (PO)mTab, element, (AbstractElementHandler)this);
        if (mTab.getAD_Tab_ID() == 0 && this.isOfficialId(element, "AD_Tab_ID")) {
            mTab.setAD_Tab_ID(this.getIntValue(element, "AD_Tab_ID"));
        }
        Element columnElement = (Element)element.properties.get("AD_Column_ID");
        int AD_Column_ID = 0;
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            AD_Column_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else if (columnElement.contents != null && columnElement.contents.length() > 0) {
            AD_Column_ID = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", columnElement.contents.toString(), "AD_Table", mTab.getAD_Table_ID());
        }
        mTab.setAD_Column_ID(AD_Column_ID);
        columnElement = (Element)element.properties.get("AD_ColumnSortOrder_ID");
        AD_Column_ID = 0;
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            AD_Column_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else if (columnElement.contents != null && columnElement.contents.length() > 0) {
            AD_Column_ID = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", columnElement.contents.toString(), "AD_Table", mTab.getAD_Table_ID());
        }
        mTab.setAD_ColumnSortOrder_ID(AD_Column_ID);
        columnElement = (Element)element.properties.get("AD_ColumnSortYesNo_ID");
        AD_Column_ID = 0;
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            AD_Column_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else if (columnElement.contents != null && columnElement.contents.length() > 0) {
            AD_Column_ID = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", columnElement.contents.toString(), "AD_Table", mTab.getAD_Table_ID());
        }
        mTab.setAD_ColumnSortYesNo_ID(AD_Column_ID);
        List notfounds = filler.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mTab.is_new()) {
            if (!mTab.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Tab", 106);
        String action = null;
        if (!mTab.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Tab", (PO)mTab);
            action = "Update";
        } else {
            action = "New";
        }
        if (mTab.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mTab.getName(), mTab.get_ID(), action);
            element.recordId = mTab.getAD_Tab_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mTab.getName(), mTab.get_ID(), action);
        throw new POSaveFailedException("Failed to save Tab " + mTab.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        PackOut packOut = ctx.packOut;
        int AD_Tab_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Tab_ID");
        boolean createElement = true;
        X_AD_Tab m_Tab = new X_AD_Tab(ctx.ctx, AD_Tab_ID, this.getTrxName(ctx));
        if (ctx.packOut.getFromDate() != null && m_Tab.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            createElement = false;
        }
        if (createElement) {
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Tab", atts);
            this.createTabBinding(ctx, document, m_Tab);
        }
        String sql = "SELECT AD_Field_ID FROM AD_FIELD WHERE AD_TAB_ID = " + AD_Tab_ID + "ORDER BY SEQNO asc";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createField(ctx, document, rs.getInt("AD_Field_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                throw new DatabaseAccessException("Failed to export window tab", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (createElement) {
            document.endElement("", "", "AD_Tab");
        }
        if (m_Tab.getAD_Process_ID() > 0) {
            try {
                ElementHandler handler = packOut.getHandler("AD_Process");
                handler.packOut(packOut, document, null, m_Tab.getAD_Process_ID());
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
    }

    private void createField(PIPOContext ctx, TransformerHandler document, int AD_Field_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Field_ID", (int)AD_Field_ID);
        this.fieldHandler.create(ctx, document);
        ctx.ctx.remove("AD_Field_ID");
    }

    private void createTabBinding(PIPOContext ctx, TransformerHandler document, X_AD_Tab m_Tab) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Tab);
        List excludes = this.defaultExcludeList("AD_Tab");
        if (m_Tab.getAD_Tab_ID() <= 999999) {
            filler.add("AD_Tab_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Tab_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Tab_ID");
    }
}

