/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_User_Roles;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UserRoleElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        int roleid = 0;
        int userid = 0;
        int orgid = 0;
        List excludes = this.defaultExcludeList("AD_User_Roles");
        X_AD_User_Roles po = (X_AD_User_Roles)this.findPO(ctx, element);
        if (po == null) {
            Element userElement = (Element)element.properties.get("AD_User_ID");
            userid = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)userElement, (String)this.getTrxName(ctx));
            if (userid <= 0) {
                element.defer = true;
                element.unresolved = "AD_User_ID " + (userElement.contents != null ? userElement.contents.toString() : "");
                return;
            }
            if (this.getParentId(element, "AD_Role") > 0) {
                roleid = this.getParentId(element, "AD_Role");
            } else {
                Element roleElement = (Element)element.properties.get("AD_Role_ID");
                roleid = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)roleElement, (String)this.getTrxName(ctx));
            }
            if (roleid <= 0) {
                element.defer = true;
                element.unresolved = "AD_Role_ID";
                return;
            }
            Element orgElement = (Element)element.properties.get("AD_Org_ID");
            orgid = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)orgElement, (String)this.getTrxName(ctx));
            Query query = new Query(ctx.ctx, "AD_User_Roles", "AD_User_ID = ? AND AD_Role_ID = ? AND AD_Org_ID = ?", this.getTrxName(ctx));
            po = (X_AD_User_Roles)query.setParameters(new Object[]{userid, roleid, orgid}).first();
            if (po == null) {
                po = new X_AD_User_Roles(ctx.ctx, 0, this.getTrxName(ctx));
                po.setAD_Org_ID(orgid);
                po.setAD_Role_ID(roleid);
                po.setAD_User_ID(userid);
            }
            excludes.add("AD_User_ID");
            excludes.add("AD_Role_ID");
            excludes.add("AD_Org_ID");
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)po, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        po.saveEx();
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_User_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_User_ID");
        int AD_Role_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Role_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Org_ID");
        Query query = new Query(ctx.ctx, "AD_User_Roles", "AD_User_ID = ? AND AD_Role_ID = ? AND AD_Org_ID = ?", this.getTrxName(ctx));
        X_AD_User_Roles po = (X_AD_User_Roles)query.setParameters(new Object[]{AD_User_ID, AD_Role_ID, AD_Org_ID}).first();
        if (po != null) {
            if (ctx.packOut.getFromDate() != null && po.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_User_Roles", atts);
            this.createUserAssignBinding(ctx, document, po);
            document.endElement("", "", "AD_User_Roles");
        }
    }

    private void createUserAssignBinding(PIPOContext ctx, TransformerHandler document, X_AD_User_Roles po) {
        PoExporter filler = new PoExporter(ctx, document, (PO)po);
        AttributesImpl orgRefAtts = new AttributesImpl();
        String orgReference = ReferenceUtils.getTableReference((String)"AD_Org", (String)"Name", (int)po.getAD_Org_ID(), (AttributesImpl)orgRefAtts);
        filler.addString("AD_Org_ID", orgReference, orgRefAtts);
        List excludes = this.defaultExcludeList("AD_User_Roles");
        excludes.add("AD_Org_ID");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        this.create(packout.getCtx(), packoutHandler);
    }
}

