/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MColumn;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeNextConditionElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes = this.defaultExcludeList("AD_WF_NextCondition");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MWFNextCondition mWFNodeNextCondition = (MWFNextCondition)this.findPO(ctx, element);
        if (mWFNodeNextCondition == null) {
            int workflowId = 0;
            Element wfElement = (Element)element.properties.get("AD_Workflow_ID");
            workflowId = this.getParentId(element, "AD_Workflow") > 0 ? this.getParentId(element, "AD_Workflow") : ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)wfElement, (String)this.getTrxName(ctx));
            if (workflowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Workflow: " + wfElement.contents;
                return;
            }
            Element nextElement = (Element)element.properties.get("AD_WF_NodeNext_ID");
            int wfNodeNextId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)nextElement, (String)this.getTrxName(ctx));
            if (wfNodeNextId <= 0) {
                element.unresolved = "AD_WF_NodeNext=" + nextElement.contents;
                element.defer = true;
                return;
            }
            int seqNo = this.getIntValue(element, "SeqNo");
            String sql = "SELECT AD_WF_NextCondition_ID FROM AD_WF_NextCondition WHERE AD_WF_NodeNext_ID =? AND SeqNo=?";
            int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)sql, (Object[])new Object[]{wfNodeNextId, seqNo});
            mWFNodeNextCondition = new MWFNextCondition(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            mWFNodeNextCondition.setAD_WF_NodeNext_ID(wfNodeNextId);
        }
        PoFiller filler = new PoFiller(ctx, (PO)mWFNodeNextCondition, element, (AbstractElementHandler)this);
        if (mWFNodeNextCondition.get_ID() == 0 && this.isOfficialId(element, "AD_WF_NextCondition_ID")) {
            filler.setInteger("AD_WF_NextCondition_ID");
        }
        Element tableElement = (Element)element.properties.get("AD_Table_ID");
        Element columnElement = (Element)element.properties.get("AD_Column_ID");
        int columnId = 0;
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            columnId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else {
            int AD_Table_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)tableElement, (String)this.getTrxName(ctx));
            columnId = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", columnElement.contents.toString(), "AD_Table", AD_Table_ID);
        }
        mWFNodeNextCondition.setAD_Column_ID(columnId);
        List notfounds = filler.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mWFNodeNextCondition.is_new()) {
            if (!mWFNodeNextCondition.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_WF_NextCondition", 706);
        String action = null;
        if (!mWFNodeNextCondition.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_WF_NextCondition", (PO)mWFNodeNextCondition);
            action = "Update";
        } else {
            action = "New";
        }
        if (mWFNodeNextCondition.save(this.getTrxName(ctx))) {
            this.log.info("m_WFNodeNextCondition save success");
            this.logImportDetail(ctx, impDetail, 1, String.valueOf(mWFNodeNextCondition.get_ID()), mWFNodeNextCondition.get_ID(), action);
            return;
        }
        this.log.info("m_WFNodeNextCondition save failure");
        this.logImportDetail(ctx, impDetail, 0, String.valueOf(mWFNodeNextCondition.get_ID()), mWFNodeNextCondition.get_ID(), action);
        throw new POSaveFailedException("Failed to save WorkflowNodeNextCondition");
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int ad_wf_nodenextcondition_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_WF_NextCondition_ID");
        MWFNextCondition m_WF_NodeNextCondition = new MWFNextCondition(ctx.ctx, ad_wf_nodenextcondition_id, null);
        if (ctx.packOut.getFromDate() != null && m_WF_NodeNextCondition.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_WF_NextCondition", atts);
        this.createWorkflowNodeNextConditionBinding(ctx, document, m_WF_NodeNextCondition);
        document.endElement("", "", "AD_WF_NextCondition");
    }

    private void createWorkflowNodeNextConditionBinding(PIPOContext ctx, TransformerHandler document, MWFNextCondition mWFNodeNextCondition) {
        PoExporter filler = new PoExporter(ctx, document, (PO)mWFNodeNextCondition);
        List excludes = this.defaultExcludeList("AD_WF_NextCondition");
        if (mWFNodeNextCondition.getAD_WF_NextCondition_ID() <= 999999) {
            filler.add("AD_WF_NextCondition_ID", new AttributesImpl());
        }
        MWFNodeNext mWFNodeNext = new MWFNodeNext(ctx.ctx, mWFNodeNextCondition.getAD_WF_NodeNext_ID(), this.getTrxName(ctx));
        MWFNode mWFNode = new MWFNode(ctx.ctx, mWFNodeNext.getAD_WF_Node_ID(), this.getTrxName(ctx));
        int AD_workflow_ID = mWFNode.getAD_Workflow_ID();
        AttributesImpl wfAttributes = new AttributesImpl();
        String value = ReferenceUtils.getTableReference((String)"AD_Workflow", (String)"Value", (int)AD_workflow_ID, (AttributesImpl)wfAttributes);
        filler.addString("AD_Workflow_ID", value, wfAttributes);
        int AD_WF_Node_ID = mWFNodeNext.getAD_WF_Node_ID();
        AttributesImpl wfnAttributes = new AttributesImpl();
        value = ReferenceUtils.getTableReference((String)"AD_WF_Node", (String)"Value", (int)AD_WF_Node_ID, (AttributesImpl)wfnAttributes);
        filler.addString("AD_WF_Node_ID", value, wfnAttributes);
        int AD_WF_Next_ID = mWFNodeNext.getAD_WF_Next_ID();
        AttributesImpl nextAttributes = new AttributesImpl();
        value = ReferenceUtils.getTableReference((String)"AD_WF_Node", (String)"Value", (int)AD_WF_Next_ID, (AttributesImpl)nextAttributes);
        filler.addString("AD_WF_Next_ID", value, nextAttributes);
        if (mWFNodeNextCondition.getAD_Column_ID() > 0) {
            int AD_Column_ID = mWFNodeNextCondition.getAD_Column_ID();
            MColumn mColumn = new MColumn(ctx.ctx, AD_Column_ID, this.getTrxName(ctx));
            int AD_Table_ID = mColumn.getAD_Table_ID();
            AttributesImpl tableAttributes = new AttributesImpl();
            value = ReferenceUtils.getTableReference((String)"AD_Table", (String)"TableName", (int)AD_Table_ID, (AttributesImpl)tableAttributes);
            filler.addString("AD_Table_ID", value, tableAttributes);
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_WF_NextCondition_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_WF_NextCondition_ID");
    }
}

