/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.util.logging.Level;
import org.compiere.util.CLogger;

public class AdempiereServerGroup
extends ThreadGroup {
    private static volatile AdempiereServerGroup s_group = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public static AdempiereServerGroup get() {
        if (s_group == null || s_group.isDestroyed()) {
            s_group = new AdempiereServerGroup();
        }
        return s_group;
    }

    private AdempiereServerGroup() {
        super("AdempiereServers");
        this.setDaemon(true);
        this.setMaxPriority(10);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(this.getName()) + " - Parent=" + this.getParent());
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("uncaughtException = " + e.toString());
        }
        super.uncaughtException(t, e);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void dump() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.getName()) + (this.isDestroyed() ? " (destroyed)" : ""));
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("- Parent=" + this.getParent());
        }
        Thread[] list = new Thread[this.activeCount()];
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("- Count=" + this.enumerate(list, true));
        }
        int i = 0;
        while (i < list.length) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("-- " + list[i]);
            }
            ++i;
        }
    }
}

