/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.model.MSystem;
import org.compiere.server.AdempiereServerGroup;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CMemoryUsage;
import org.compiere.util.CacheMgt;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;

public class AdempiereMonitor
extends HttpServlet {
    private static final long serialVersionUID = -387582087015910664L;
    private static CLogger log = CLogger.getCLogger(AdempiereMonitor.class);
    private static AdempiereServerMgr m_serverMgr = null;
    private static p m_message = null;
    private static volatile ArrayList<File> m_dirAccessList = null;
    private static final String s_dirAccessFileName = "dirAccess.txt";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean xmlOutput = false;
        String responseType = request.getParameter("responseContentType");
        xmlOutput = "xml".equalsIgnoreCase(responseType);
        m_message = null;
        if (this.processLogParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processTraceParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processEMailParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (this.processCacheParameter(request, response)) {
            if (xmlOutput) {
                this.createXMLSummaryPage(request, response);
            }
            return;
        }
        if (!this.processRunNowParameter(request)) {
            this.processActionParameter(request, response);
        }
        if (xmlOutput) {
            this.createXMLSummaryPage(request, response);
        } else {
            this.createSummaryPage(request, response, false);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private boolean processLogParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AdempiereServerMgr.ServerWrapper server;
        String serverID = WebUtil.getParameter((HttpServletRequest)request, (String)"Log");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("ServerID=" + serverID);
        }
        if ((server = m_serverMgr.getServer(serverID)) == null || server.getServer() == null) {
            m_message = new p();
            m_message.addElement((Element)new strong("Server not found: "));
            m_message.addElement(serverID);
            return false;
        }
        WebDoc doc = WebDoc.create((String)"iDempiere Server Monitor Log");
        body b = doc.getBody();
        p para = new p();
        a link = new a("idempiereMonitor#" + serverID, "Return");
        para.addElement((Element)link);
        b.addElement((Element)para);
        b.addElement((Element)new h2(server.getServer().getName()));
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement("Created"));
        line.addElement((Element)new th().addElement("Summary"));
        line.addElement((Element)new th().addElement("Reference"));
        line.addElement((Element)new th().addElement("TextMsg"));
        table2.addElement((Element)line);
        AdempiereProcessorLog[] logs = server.getServer().getLogs();
        int i = 0;
        while (i < logs.length) {
            AdempiereProcessorLog pLog = logs[i];
            line = new tr();
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getCreated())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getSummary())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getReference())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)pLog.getTextMsg())));
            table2.addElement((Element)line);
            ++i;
        }
        b.addElement((Element)table2);
        link = new a("#top", "Top");
        b.addElement((Element)link);
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
        return true;
    }

    private boolean processRunNowParameter(HttpServletRequest request) throws ServletException, IOException {
        AdempiereServerMgr.ServerWrapper server;
        String serverID = WebUtil.getParameter((HttpServletRequest)request, (String)"RunNow");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("ServerID=" + serverID);
        }
        if ((server = m_serverMgr.getServer(serverID)) == null || server.getServer() == null) {
            m_message = new p();
            m_message.addElement((Element)new strong("Server not found: "));
            m_message.addElement(serverID);
            return false;
        }
        server.getServer().runNow();
        return true;
    }

    private void processActionParameter(HttpServletRequest request, HttpServletResponse response) {
        String action = WebUtil.getParameter((HttpServletRequest)request, (String)"Action");
        if (action == null || action.length() == 0) {
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Action=" + action);
        }
        try {
            boolean start = action.startsWith("Start");
            boolean reload = action.startsWith("Reload");
            m_message = new p();
            String msg = String.valueOf(start ? "Started" : "Stopped") + ": ";
            m_message.addElement((Element)new strong(msg));
            String serverID = action.substring(action.indexOf(95) + 1);
            boolean ok = false;
            if (serverID.equals("All")) {
                ok = start ? m_serverMgr.startAll() : m_serverMgr.stopAll();
                m_message.addElement("All");
            } else if (reload) {
                m_serverMgr.stopAll();
                ok = m_serverMgr.startServers();
                this.createSummaryPage(request, response, true);
                m_dirAccessList = this.getDirAcessList();
            } else {
                AdempiereServerMgr.ServerWrapper server = m_serverMgr.getServer(serverID);
                if (server == null || server.getServer() == null) {
                    m_message = new p();
                    m_message.addElement((Element)new strong("Server not found: "));
                    m_message.addElement(serverID);
                    return;
                }
                ok = start ? m_serverMgr.start(serverID) : m_serverMgr.stop(serverID);
                m_message.addElement(server.getServer().getName());
            }
            m_message.addElement(ok ? " - OK" : " - Error!");
        }
        catch (Exception e) {
            m_message = new p();
            m_message.addElement((Element)new strong("Error processing parameter: " + action));
            m_message.addElement((Element)new br());
            m_message.addElement(e.toString());
        }
    }

    private boolean processTraceParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        String traceCmd = WebUtil.getParameter((HttpServletRequest)request, (String)"Trace");
        String traceLevel = WebUtil.getParameter((HttpServletRequest)request, (String)"TraceLevel");
        if (traceLevel != null && traceLevel.length() > 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("New Level: " + traceLevel);
            }
            CLogMgt.setLevel((String)traceLevel);
            Ini.setProperty((String)"TraceLevel", (String)traceLevel);
            Ini.saveProperties((boolean)false);
            return false;
        }
        if (traceCmd == null || traceCmd.length() == 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Command: " + traceCmd);
        }
        CLogFile fileHandler = CLogFile.get((boolean)false, null, (boolean)false);
        if (traceCmd.equals("ROTATE")) {
            if (fileHandler != null) {
                fileHandler.rotateLog();
            }
            return false;
        }
        if (traceCmd.equals("DELETE")) {
            File logDir = fileHandler.getLogDirectory();
            if (logDir != null && logDir.isDirectory()) {
                File[] logs = logDir.listFiles();
                int i = 0;
                while (i < logs.length) {
                    String fileName = logs[i].getAbsolutePath();
                    if (!fileName.equals(fileHandler.getFileName())) {
                        if (logs[i].delete()) {
                            log.warning("Deleted: " + fileName);
                        } else {
                            log.warning("Not Deleted: " + fileName);
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
        if (fileHandler != null && fileHandler.getFileName().equals(traceCmd)) {
            fileHandler.flush();
        }
        if (!(file = new File(traceCmd)).exists() || !file.canRead()) {
            log.warning("Did not find File: " + traceCmd);
            return false;
        }
        if (file.length() == 0L) {
            log.warning("File Length=0: " + traceCmd);
            return false;
        }
        boolean found = false;
        if (m_dirAccessList == null) {
            m_dirAccessList = this.getDirAcessList();
        }
        for (File dir : m_dirAccessList) {
            if (!file.getCanonicalPath().startsWith(dir.getAbsolutePath())) continue;
            found = true;
            break;
        }
        if (!found) {
            log.warning("Couldn't find file in directories that allowed to access");
            for (File dirAccess : m_dirAccessList) {
                log.warning(" - " + dirAccess.getAbsoluteFile());
            }
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Streaming: " + traceCmd);
        }
        try {
            long time = System.currentTimeMillis();
            int fileLength = (int)file.length();
            int bufferSize = 2048;
            byte[] buffer = new byte[bufferSize];
            FileInputStream fis = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("text/plain");
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            int read = 0;
            while ((read = fis.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            fis.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)fileLength / 1024.0 / ((double)time / 1000.0);
            if (log.isLoggable(Level.INFO)) {
                log.info("length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "stream" + ex);
            return false;
        }
        return true;
    }

    private boolean processEMailParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String email = WebUtil.getParameter((HttpServletRequest)request, (String)"EMail");
        if (email == null || email.length() == 0) {
            return false;
        }
        int AD_Client_ID = -1;
        try {
            AD_Client_ID = Integer.parseInt(email);
        }
        catch (Exception e) {
            log.warning("Parsing: " + email + " - " + e.toString());
        }
        if (AD_Client_ID < 0) {
            m_message = new p();
            m_message.addElement("No EMail: " + email);
            return false;
        }
        MClient client = MClient.get((Properties)new Properties(), (int)AD_Client_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info("Test: " + client);
        }
        m_message = new p();
        m_message.addElement(String.valueOf(client.getName()) + ": " + client.testEMail());
        return false;
    }

    private boolean processCacheParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheReset");
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        String tableName = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheTableName");
        String record_ID = WebUtil.getParameter((HttpServletRequest)request, (String)"CacheRecord_ID");
        m_message = new p();
        try {
            if (tableName == null || tableName.length() == 0) {
                CacheMgt.get().reset();
                m_message.addElement("Cache Reset: All");
            } else if (record_ID == null || record_ID.length() == 0) {
                CacheMgt.get().reset(tableName);
                m_message.addElement("Cache Reset: " + tableName);
            } else {
                CacheMgt.get().reset(tableName, Integer.parseInt(record_ID));
                m_message.addElement("Cache Reset: " + tableName + ", Record_ID=" + record_ID);
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            m_message.addElement("Error: " + e.toString());
        }
        return false;
    }

    private void createSummaryPage(HttpServletRequest request, HttpServletResponse response, boolean refresh) throws ServletException, IOException {
        AdempiereServerMgr.ServerWrapper server;
        WebDoc doc = WebDoc.create((String)"iDempiere Server Monitor");
        AdempiereServerGroup.get().dump();
        body bb = new body();
        bb = doc.getBody();
        if (m_message != null) {
            bb.addElement((Element)new hr());
            bb.addElement((Element)m_message);
            bb.addElement((Element)new hr());
        }
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getName()));
        line.addElement((Element)new td().addElement(Adempiere.getVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getImplementationVendor()));
        line.addElement((Element)new td().addElement(Adempiere.getImplementationVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Manager"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)m_serverMgr.getDescription())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Start - Elapsed"));
        line.addElement((Element)new td().addElement(String.valueOf(WebEnv.getCellContent((Object)m_serverMgr.getStartTime())) + " - " + TimeUtil.formatElapsed((Timestamp)m_serverMgr.getStartTime())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Servers"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)m_serverMgr.getServerCount())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Last Updated"));
        line.addElement((Element)new td().addElement(new Timestamp(System.currentTimeMillis()).toString()));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p para = new p();
        a link = new a("idempiereMonitor?Action=Start_All", "Start All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor?Action=Stop_All", "Stop All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor?Action=Reload", "Reload");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("idempiereMonitor", "Refresh");
        para.addElement((Element)link);
        bb.addElement((Element)para);
        bb.addElement((Element)new hr());
        para = new p();
        AdempiereServerMgr.ServerWrapper[] servers = m_serverMgr.getAll();
        int i = 0;
        while (i < servers.length) {
            if (i > 0) {
                para.addElement((Element)new br());
            }
            server = servers[i];
            link = new a("#" + server.getServer().getServerID(), server.getServer().getName());
            para.addElement((Element)link);
            font status = null;
            status = server.isAlive() ? new font().setColor("#008000").addElement(" (Running)") : new font().setColor("#FF0000").addElement(" (Stopped)");
            para.addElement((Element)status);
            ++i;
        }
        bb.addElement((Element)para);
        this.createLogMgtPage(bb);
        bb.removeEndEndModifier();
        i = 0;
        while (i < servers.length) {
            String msg;
            server = servers[i];
            bb.addElement((Element)new hr());
            bb.addElement((Element)new a().setName(server.getServer().getServerID()));
            bb.addElement((Element)new h2(server.getServer().getName()));
            table2 = new table();
            table2.setBorder(1);
            table2.setCellSpacing(2);
            table2.setCellPadding(2);
            line = new tr();
            if (server.isAlive()) {
                msg = "Stop";
                link = new a("idempiereMonitor?Action=Stop_" + server.getServer().getServerID(), msg);
                if (server.getServer().isSleeping()) {
                    line.addElement((Element)new th().addElement("Sleeping"));
                    line.addElement((Element)new td().addElement((Element)link));
                } else {
                    line.addElement((Element)new th().addElement("Running"));
                    line.addElement((Element)new td().addElement((Element)link));
                }
                table2.addElement((Element)line);
                line = new tr();
                line.addElement((Element)new th().addElement("Start - Elapsed"));
                line.addElement((Element)new td().addElement(String.valueOf(WebEnv.getCellContent((Object)server.getServer().getStartTime())) + " - " + TimeUtil.formatElapsed((Timestamp)server.getServer().getStartTime())));
            } else {
                msg = "Start";
                line.addElement((Element)new th().addElement("Not Started"));
                link = new a("idempiereMonitor?Action=Start_" + server.getServer().getServerID(), msg);
                line.addElement((Element)new td().addElement((Element)link));
            }
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Description"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)server.getServer().getDescription())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Last Run"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)server.getServer().getDateLastRun())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Info"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent((Object)server.getServer().getServerInfo())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Next Run"));
            td td2 = new td();
            td2.addElement(WebEnv.getCellContent((Object)server.getServer().getDateNextRun(false)));
            td2.addElement(" - ");
            link = new a("idempiereMonitor?RunNow=" + server.getServer().getServerID(), "(Run Now)");
            td2.addElement((Element)link);
            line.addElement((Element)td2);
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Statistics"));
            line.addElement((Element)new td().addElement(server.getServer().getStatistics()));
            table2.addElement((Element)line);
            bb.addElement((Element)table2);
            link = new a("#top", "Top");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("idempiereMonitor?Log=" + server.getServer().getServerID(), "Log");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("idempiereMonitor", "Refresh");
            bb.addElement((Element)link);
            ++i;
        }
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
    }

    private void createXMLSummaryPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        PrintWriter writer = response.getWriter();
        writer.println("<server-response>");
        writer.println("\t<message>");
        if (m_message != null) {
            writer.println(m_message);
        }
        writer.println("\t</message>");
        writer.print("\t<name>");
        writer.print(Adempiere.getName());
        writer.println("</name>");
        writer.print("\t<version>");
        writer.print(Adempiere.getVersion());
        writer.println("</version>");
        writer.print("\t<implementation-vendor>");
        writer.print(Adempiere.getImplementationVendor());
        writer.println("</implementation-vendor>");
        writer.print("\t<implementation-version>");
        writer.print(Adempiere.getImplementationVersion());
        writer.println("</implementation-version>");
        writer.println("\t<server-manager>");
        writer.print("\t\t<description>");
        writer.print(m_serverMgr.getDescription());
        writer.println("</description>");
        writer.print("\t\t<start-time>");
        writer.print(m_serverMgr.getStartTime());
        writer.println("</start-time>");
        writer.print("\t\t<server-count>");
        writer.print(m_serverMgr.getServerCount());
        writer.println("</server-count>");
        AdempiereServerMgr.ServerWrapper[] servers = m_serverMgr.getAll();
        int i = 0;
        while (i < servers.length) {
            AdempiereServerMgr.ServerWrapper server = servers[i];
            writer.println("\t\t<server>");
            writer.print("\t\t\t<id>");
            writer.print(server.getServer().getServerID());
            writer.println("</id>");
            writer.print("\t\t\t<name>");
            writer.print(server.getServer().getName());
            writer.println("</name>");
            writer.print("\t\t\t<description>");
            writer.print(server.getServer().getDescription());
            writer.println("</description>");
            writer.print("\t\t\t<info>");
            writer.print(server.getServer().getServerInfo());
            writer.println("</info>");
            writer.print("\t\t\t<status>");
            if (server.isAlive()) {
                if (server.isInterrupted()) {
                    writer.print("Interrupted");
                } else if (server.getServer().isSleeping()) {
                    writer.print("Sleeping");
                } else {
                    writer.print("Running");
                }
            } else {
                writer.print("Stopped");
            }
            writer.println("</status>");
            writer.print("\t\t\t<start-time>");
            writer.print(server.getServer().getStartTime());
            writer.println("</start-time>");
            writer.print("\t\t\t<last-run>");
            writer.print(server.getServer().getDateLastRun());
            writer.println("</last-run>");
            writer.print("\t\t\t<next-run>");
            writer.print(server.getServer().getDateNextRun(false));
            writer.println("</next-run>");
            writer.print("\t\t\t<statistics>");
            writer.print(server.getServer().getStatistics());
            writer.println("</statistics>");
            writer.println("\t\t</server>");
            ++i;
        }
        writer.println("\t</server-manager>");
        writer.flush();
    }

    private void createLogMgtPage(body bb) {
        int i;
        Trx[] trxs;
        bb.addElement((Element)new hr());
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        Properties ctx = new Properties();
        MSystem system = MSystem.get((Properties)ctx);
        tr line = new tr();
        line.addElement((Element)new th().addElement(system.getDBAddress()));
        line.addElement((Element)new td().addElement(Ini.getAdempiereHome()));
        table2.addElement((Element)line);
        line = new tr();
        String info = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
        String s = System.getProperty("sun.os.patch.level");
        if (s != null && s.length() > 0) {
            info = String.valueOf(info) + " (" + s + ")";
        }
        line.addElement((Element)new th().addElement(info));
        info = system.getName();
        if (system.getCustomPrefix() != null) {
            info = String.valueOf(info) + " (" + system.getCustomPrefix() + ")";
        }
        line.addElement((Element)new td().addElement(info));
        table2.addElement((Element)line);
        line = new tr();
        info = String.valueOf(System.getProperty("java.vm.name")) + " " + System.getProperty("java.vm.version");
        line.addElement((Element)new th().addElement(info));
        line.addElement((Element)new td().addElement(system.getUserName()));
        table2.addElement((Element)line);
        line = new tr();
        CConnection cc = CConnection.get();
        AdempiereDatabase db = cc.getDatabase();
        info = db.getDescription();
        line.addElement((Element)new th().addElement(info));
        line.addElement((Element)new td().addElement(cc.getConnectionURL()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("DB Connection Pool"));
        line.addElement((Element)new td().addElement(cc.getDatabase().getStatus()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Processor/Support"));
        line.addElement((Element)new td().addElement(String.valueOf(system.getNoProcessors()) + "/" + system.getSupportUnits()));
        table2.addElement((Element)line);
        line = new tr();
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        line.addElement((Element)new th().addElement("VM Memory"));
        line.addElement((Element)new td().addElement(new CMemoryUsage(memory.getNonHeapMemoryUsage()).toString()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Heap Memory"));
        line.addElement((Element)new td().addElement(new CMemoryUsage(memory.getHeapMemoryUsage()).toString()));
        table2.addElement((Element)line);
        line = new tr();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        line.addElement((Element)new th().addElement("Runtime " + rt.getName()));
        line.addElement((Element)new td().addElement(TimeUtil.formatElapsed((long)rt.getUptime())));
        table2.addElement((Element)line);
        line = new tr();
        ThreadMXBean th2 = ManagementFactory.getThreadMXBean();
        line.addElement((Element)new th().addElement("Threads " + th2.getThreadCount()));
        line.addElement((Element)new td().addElement("Peak=" + th2.getPeakThreadCount() + ", Demons=" + th2.getDaemonThreadCount() + ", Total=" + th2.getTotalStartedThreadCount()));
        table2.addElement((Element)line);
        Trx[] trxArray = trxs = Trx.getActiveTransactions();
        int n = trxs.length;
        int n2 = 0;
        while (n2 < n) {
            Trx trx = trxArray[n2];
            if (trx != null && trx.isActive()) {
                line = new tr();
                line.addElement((Element)new th().addElement("Active Transaction "));
                line.addElement((Element)new td().addElement("Name=" + trx.getTrxName() + ", StartTime=" + trx.getStartTime()));
                table2.addElement((Element)line);
            }
            ++n2;
        }
        line = new tr();
        line.addElement((Element)new th().addElement(CacheMgt.get().toStringX()));
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?CacheReset=Yes", "Reset Cache")));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement((Element)new label("TraceLevel").addElement("Trace Log Level")));
        form myForm = new form("idempiereMonitor", "post", "application/x-www-form-urlencoded");
        option[] options = new option[CLogMgt.LEVELS.length];
        int i2 = 0;
        while (i2 < options.length) {
            options[i2] = new option(CLogMgt.LEVELS[i2].getName());
            options[i2].addElement(CLogMgt.LEVELS[i2].getName());
            if (CLogMgt.LEVELS[i2] == CLogMgt.getLevel()) {
                options[i2].setSelected(true);
            }
            ++i2;
        }
        select sel = new select("TraceLevel", options);
        myForm.addElement((Element)sel);
        myForm.addElement((Element)new input("submit", "Set", "Set"));
        line.addElement((Element)new td().addElement((Element)myForm));
        table2.addElement((Element)line);
        line = new tr();
        CLogFile fileHandler = CLogFile.get((boolean)true, null, (boolean)false);
        line.addElement((Element)new th().addElement("Trace File"));
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?Trace=" + fileHandler.getFileName(), "Current")));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?Trace=ROTATE", "Rotate Trace Log")));
        line.addElement((Element)new td().addElement((Element)new a("idempiereMonitor?Trace=DELETE", "Delete all Trace Logs")));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p p2 = new p();
        p2.addElement((Element)new b("All Log Files: "));
        File logDir = fileHandler.getLogDirectory();
        if (logDir != null && logDir.isDirectory()) {
            File[] logs = logDir.listFiles();
            i = 0;
            while (i < logs.length) {
                if (logs[i].isFile()) {
                    if (i != 0) {
                        p2.addElement(" - ");
                    }
                    String fileName = logs[i].getAbsolutePath();
                    a link = new a("idempiereMonitor?Trace=" + fileName, fileName);
                    p2.addElement((Element)link);
                    int size = (int)(logs[i].length() / 1024L);
                    if (size < 1024) {
                        p2.addElement(" (" + size + "k)");
                    } else {
                        p2.addElement(" (" + size / 1024 + "M)");
                    }
                }
                ++i;
            }
        }
        bb.addElement((Element)p2);
        table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        line = new tr();
        MClient[] clients = MClient.getAll((Properties)ctx);
        line.addElement((Element)new th().addElement("Client #" + clients.length + " - EMail Test:"));
        p2 = new p();
        i = 0;
        while (i < clients.length) {
            MClient client = clients[i];
            if (i > 0) {
                p2.addElement(" - ");
            }
            p2.addElement((Element)new a("idempiereMonitor?EMail=" + client.getAD_Client_ID(), client.getName()));
            ++i;
        }
        if (clients.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        line = new tr();
        MStore[] wstores = MStore.getActive();
        line.addElement((Element)new th().addElement("Active Web Stores #" + wstores.length));
        p2 = new p();
        int i3 = 0;
        while (i3 < wstores.length) {
            MStore store = wstores[i3];
            if (i3 > 0) {
                p2.addElement(" - ");
            }
            a a2 = new a(store.getWebContext(), store.getName());
            a2.setTarget("t" + i3);
            p2.addElement((Element)a2);
            ++i3;
        }
        if (wstores.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
    }

    public void init(ServletConfig config) throws ServletException {
        WebEnv.initWeb((ServletConfig)config);
        log.info("");
        m_serverMgr = AdempiereServerMgr.get();
        m_dirAccessList = this.getDirAcessList();
    }

    public void destroy() {
        log.info("destroy");
        m_serverMgr = null;
        m_dirAccessList = null;
    }

    public void log(String message, Throwable e) {
        if (e == null) {
            log.warning(message);
        }
        log.log(Level.SEVERE, message, e);
    }

    public void log(String message) {
        log.fine(message);
    }

    public String getServletName() {
        return "AdempiereMonitor";
    }

    public String getServletInfo() {
        return "iDempiere Server Monitor";
    }

    private ArrayList<File> getDirAcessList() {
        ArrayList<File> dirAccessList = new ArrayList<File>();
        CLogFile fileHandler = CLogFile.get((boolean)true, null, (boolean)false);
        File logDir = fileHandler.getLogDirectory();
        dirAccessList.add(logDir);
        String dirAccessPathName = String.valueOf(Adempiere.getAdempiereHome()) + File.separator + s_dirAccessFileName;
        File dirAccessFile = new File(dirAccessPathName);
        if (dirAccessFile.exists()) {
            try {
                String pathName;
                BufferedReader br2 = new BufferedReader(new FileReader(dirAccessFile));
                while ((pathName = br2.readLine()) != null) {
                    File pathDir = new File(pathName);
                    if (!pathDir.exists() || dirAccessList.contains(pathDir)) continue;
                    dirAccessList.add(pathDir);
                }
                br2.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, String.valueOf(dirAccessPathName) + " - " + e.toString());
            }
        }
        return dirAccessList;
    }
}

