/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.GridField;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class TabEditor {
    public MTab m_tab;
    public static CLogger log = CLogger.getCLogger(TabEditor.class);
    private List<MField> fields = new ArrayList<MField>();
    private List<GridField> gridFields = new ArrayList<GridField>();
    private MField m_activeField;
    private Map<Integer, MField> mapField = new HashMap<Integer, MField>();
    private Map<Integer, GridField> mapGridField = new HashMap<Integer, GridField>();

    public List<GridField> getGridFields() {
        return this.gridFields;
    }

    public MTab getMTab() {
        return this.m_tab;
    }

    public List<MField> getMFields() {
        return this.fields;
    }

    protected void initMFields(int windowNo, int tabid) {
        GridField[] l_gridFields;
        this.m_tab = new MTab(Env.getCtx(), tabid, null);
        GridField[] gridFieldArray = l_gridFields = GridField.createFields((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)tabid);
        int n = l_gridFields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField gridField = gridFieldArray[n2];
            this.gridFields.add(gridField);
            this.mapGridField.put(gridField.getAD_Field_ID(), gridField);
            MField field = new MField(Env.getCtx(), gridField.getAD_Field_ID(), null);
            this.fields.add(field);
            this.mapField.put(field.getAD_Field_ID(), field);
            gridField.getVO().IsReadOnly = true;
            gridField.getVO().IsMandatory = false;
            gridField.getVO().IsUpdateable = false;
            gridField.getVO().IsAlwaysUpdateable = false;
            ++n2;
        }
        this.resortArrays();
    }

    public boolean cmd_save() {
        for (MField field : this.fields) {
            if (!field.isActive()) continue;
            field.saveEx();
        }
        return true;
    }

    protected MField getMField(int fieldid) {
        return this.mapField.get(fieldid);
    }

    protected GridField getGridField(MField field) {
        return this.mapGridField.get(field.getAD_Field_ID());
    }

    public MField getActiveMField() {
        return this.m_activeField;
    }

    protected void setActiveMField(MField field) {
        this.m_activeField = field;
    }

    protected void resortArrays() {
        Collections.sort(this.fields, new Comparator<MField>(){

            @Override
            public int compare(MField field1, MField field2) {
                String compare1 = String.format("%s%10d%s", field1.isDisplayed() ? "0" : "1", field1.isDisplayed() ? field1.getSeqNo() : 0, field1.getName());
                String compare2 = String.format("%s%10d%s", field2.isDisplayed() ? "0" : "1", field2.isDisplayed() ? field2.getSeqNo() : 0, field2.getName());
                return compare1.compareTo(compare2);
            }
        });
        int seq = 10;
        for (MField field : this.fields) {
            if (field.isDisplayed()) {
                field.setSeqNo(seq);
                seq += 10;
                continue;
            }
            field.setSeqNo(0);
        }
        Collections.sort(this.gridFields, new Comparator<GridField>(){

            @Override
            public int compare(GridField f1, GridField f2) {
                MField field1 = TabEditor.this.getMField(f1.getAD_Field_ID());
                MField field2 = TabEditor.this.getMField(f2.getAD_Field_ID());
                String compare1 = String.format("%s%10d%s", field1.isDisplayed() ? "0" : "1", field1.isDisplayed() ? field1.getSeqNo() : 0, field1.getName());
                String compare2 = String.format("%s%10d%s", field2.isDisplayed() ? "0" : "1", field2.isDisplayed() ? field2.getSeqNo() : 0, field2.getName());
                return compare1.compareTo(compare2);
            }
        });
    }
}

