/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TranslationHandler
extends DefaultHandler {
    private int m_AD_Client_ID = -1;
    private String m_AD_Language = null;
    private boolean m_isBaseLanguage = false;
    private String m_TableName = null;
    private String m_updateSQL = null;
    private String m_curID = null;
    private String m_trl = null;
    private String m_curColumnName = null;
    private StringBuffer m_curValue = null;
    private StringBuffer m_sql = null;
    private Timestamp m_time = new Timestamp(System.currentTimeMillis());
    private int m_updateCount = 0;
    private static CLogger log = CLogger.getCLogger(TranslationHandler.class);

    public TranslationHandler(int AD_Client_ID) {
        this.m_AD_Client_ID = AD_Client_ID;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("idempiereTrl") || qName.equals("adempiereTrl") || qName.equals("compiereTrl")) {
            this.m_AD_Language = attributes.getValue("language");
            this.m_isBaseLanguage = Language.isBaseLanguage((String)this.m_AD_Language);
            this.m_TableName = attributes.getValue("table");
            this.m_updateSQL = "UPDATE " + this.m_TableName;
            if (!this.m_isBaseLanguage) {
                this.m_updateSQL = String.valueOf(this.m_updateSQL) + "_Trl";
            }
            this.m_updateSQL = String.valueOf(this.m_updateSQL) + " SET ";
            if (log.isLoggable(Level.FINE)) {
                log.fine("AD_Language=" + this.m_AD_Language + ", Base=" + this.m_isBaseLanguage + ", TableName=" + this.m_TableName);
            }
        } else if (qName.equals("row")) {
            this.m_curID = attributes.getValue("id");
            this.m_trl = attributes.getValue("trl");
            this.m_sql = new StringBuffer();
        } else if (qName.equals("value")) {
            this.m_curColumnName = attributes.getValue("column");
        } else {
            log.severe("UNKNOWN TAG: " + qName);
        }
        this.m_curValue = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_curValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equals("idempiereTrl") || qName.equals("adempiereTrl") || qName.equals("compiereTrl"))) {
            if (qName.equals("row")) {
                if (this.m_sql.length() > 0) {
                    this.m_sql.append(",");
                }
                this.m_sql.append("Updated=").append(DB.TO_DATE((Timestamp)this.m_time, (boolean)false));
                if (!this.m_isBaseLanguage) {
                    if (this.m_trl != null && ("Y".equals(this.m_trl) || "N".equals(this.m_trl))) {
                        this.m_sql.append(",IsTranslated='").append(this.m_trl).append("'");
                    } else {
                        this.m_sql.append(",IsTranslated='Y'");
                    }
                }
                this.m_sql.append(" WHERE ").append(this.m_TableName).append("_ID=").append(this.m_curID);
                if (!this.m_isBaseLanguage) {
                    this.m_sql.append(" AND AD_Language='").append(this.m_AD_Language).append("'");
                }
                if (this.m_AD_Client_ID >= 0) {
                    this.m_sql.append(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                }
                this.m_sql.insert(0, this.m_updateSQL);
                int no = DB.executeUpdate((String)this.m_sql.toString(), null);
                if (no == 1) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this.m_sql.toString());
                    }
                    ++this.m_updateCount;
                } else if (no == 0) {
                    log.warning("Not Found - " + this.m_sql.toString());
                } else {
                    log.severe("Update Rows=" + no + " (Should be 1) - " + this.m_sql.toString());
                }
            } else if (qName.equals("value")) {
                if (this.m_sql.length() > 0) {
                    this.m_sql.append(",");
                }
                this.m_sql.append(this.m_curColumnName).append("=").append(DB.TO_STRING((String)this.m_curValue.toString()));
            }
        }
    }

    public int getUpdateCount() {
        return this.m_updateCount;
    }
}

