/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AllocationAuto
extends SvrProcess {
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private boolean p_AllocateOldest = true;
    private String p_APAR = "A";
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private MPayment[] m_payments = null;
    private MInvoice[] m_invoices = null;
    private MAllocationHdr m_allocation = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("AllocateOldest")) {
                    this.p_AllocateOldest = "Y".equals(para[i].getParameter());
                } else if (name.equals("APAR")) {
                    this.p_APAR = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int countAlloc;
        int countBP;
        block17: {
            String sql;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", Oldest=" + this.p_AllocateOldest + ", AP/AR=" + this.p_APAR);
            }
            countBP = 0;
            countAlloc = 0;
            if (this.p_C_BPartner_ID != 0) {
                countAlloc = this.allocateBP(this.p_C_BPartner_ID);
                if (countAlloc > 0) {
                    ++countBP;
                }
            } else if (this.p_C_BP_Group_ID != 0) {
                sql = "SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID=? ORDER BY Value";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_C_BP_Group_ID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int C_BPartner_ID = rs.getInt(1);
                            int count = this.allocateBP(C_BPartner_ID);
                            if (count <= 0) continue;
                            ++countBP;
                            countAlloc += count;
                            this.commitEx();
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else {
                sql = "SELECT C_BPartner_ID FROM C_BPartner WHERE AD_Client_ID=? ORDER BY Value";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int C_BPartner_ID = rs.getInt(1);
                            int count = this.allocateBP(C_BPartner_ID);
                            if (count <= 0) continue;
                            ++countBP;
                            countAlloc += count;
                            this.commitEx();
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ #").append(countBP).append("/").append(countAlloc);
        return msgreturn.toString();
    }

    private int allocateBP(int C_BPartner_ID) throws Exception {
        int newCount;
        this.getPayments(C_BPartner_ID);
        this.getInvoices(C_BPartner_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("(1) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
        }
        if (this.m_payments.length + this.m_invoices.length < 2) {
            return 0;
        }
        int count = this.allocateBPPaymentWithInfo();
        if (count != 0) {
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("(2) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            }
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if ((newCount = this.allocateBPartnerAll()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("(3) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            }
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if ((newCount = this.allocateBPOneToOne()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("(4) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            }
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if (this.p_AllocateOldest && (newCount = this.allocateBPOldestFirst()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("(5) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            }
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        return count;
    }

    private MPayment[] getPayments(int C_BPartner_ID) {
        ArrayList<MPayment> list;
        block10: {
            list = new ArrayList<MPayment>();
            StringBuilder sql = new StringBuilder("SELECT * FROM C_Payment ").append("WHERE IsAllocated='N' AND Processed='Y' AND C_BPartner_ID=?").append(" AND IsPrepayment='N' AND C_Charge_ID IS NULL ");
            if (ONLY_AP.equals(this.p_APAR)) {
                sql.append("AND IsReceipt='N' ");
            } else if (ONLY_AR.equals(this.p_APAR)) {
                sql.append("AND IsReceipt='Y' ");
            }
            sql.append("ORDER BY DateTrx");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPayment payment = new MPayment(this.getCtx(), rs, this.get_TrxName());
                        BigDecimal allocated = payment.getAllocatedAmt();
                        if (allocated != null && allocated.compareTo(payment.getPayAmt()) == 0) {
                            payment.setIsAllocated(true);
                            payment.saveEx();
                            continue;
                        }
                        list.add(payment);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_payments = new MPayment[list.size()];
        list.toArray(this.m_payments);
        return this.m_payments;
    }

    private MInvoice[] getInvoices(int C_BPartner_ID) {
        ArrayList<MInvoice> list;
        block10: {
            list = new ArrayList<MInvoice>();
            StringBuilder sql = new StringBuilder("SELECT * FROM C_Invoice ").append("WHERE IsPaid='N' AND Processed='Y' AND C_BPartner_ID=? ");
            if (ONLY_AP.equals(this.p_APAR)) {
                sql.append("AND IsSOTrx='N' ");
            } else if (ONLY_AR.equals(this.p_APAR)) {
                sql.append("AND IsSOTrx='Y' ");
            }
            sql.append("ORDER BY DateInvoiced");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInvoice invoice = new MInvoice(this.getCtx(), rs, this.get_TrxName());
                        if (invoice.getOpenAmt(false, null).signum() == 0) {
                            invoice.setIsPaid(true);
                            invoice.saveEx();
                            continue;
                        }
                        list.add(invoice);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_invoices = new MInvoice[list.size()];
        list.toArray(this.m_invoices);
        return this.m_invoices;
    }

    private int allocateBPPaymentWithInfo() {
        int count = 0;
        int p = 0;
        while (p < this.m_payments.length) {
            MPayment payment = this.m_payments[p];
            if (!payment.isAllocated()) {
                BigDecimal allocatedAmt = payment.getAllocatedAmt();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(payment + ", Allocated=" + allocatedAmt);
                }
                if (allocatedAmt == null || allocatedAmt.signum() == 0) {
                    BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                    if (!payment.isReceipt()) {
                        availableAmt = availableAmt.negate();
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Available=" + availableAmt);
                    }
                    if (payment.getC_Invoice_ID() != 0) {
                        int i = 0;
                        while (i < this.m_invoices.length) {
                            MInvoice invoice = this.m_invoices[i];
                            if (!invoice.isPaid() && payment.getC_Invoice_ID() == invoice.getC_Invoice_ID() && payment.getC_Currency_ID() == invoice.getC_Currency_ID()) {
                                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                                if (!invoice.isSOTrx()) {
                                    openAmt = openAmt.negate();
                                }
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine(invoice + ", Open=" + openAmt);
                                }
                                if (availableAmt.compareTo(openAmt) == 0) {
                                    if (payment.allocateIt()) {
                                        String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@PaymentAllocated@ " + payment.getDocumentNo() + " [1]"));
                                        this.addLog(0, payment.getDateAcct(), openAmt, message, payment.get_Table_ID(), payment.getC_Payment_ID());
                                        ++count;
                                    }
                                    break;
                                }
                            }
                            ++i;
                        }
                    } else {
                        MPaySelectionCheck psCheck = MPaySelectionCheck.getOfPayment((Properties)this.getCtx(), (int)payment.getC_Payment_ID(), (String)this.get_TrxName());
                        if (psCheck != null) {
                            BigDecimal totalInvoice = Env.ZERO;
                            MPaySelectionLine[] psLines = psCheck.getPaySelectionLines(false);
                            int i = 0;
                            while (i < psLines.length) {
                                MPaySelectionLine line = psLines[i];
                                MInvoice invoice = line.getInvoice();
                                if (payment.getC_Currency_ID() == invoice.getC_Currency_ID()) {
                                    BigDecimal invoiceAmt = invoice.getOpenAmt(true, null);
                                    BigDecimal overUnder = line.getOpenAmt().subtract(line.getPayAmt()).subtract(line.getDiscountAmt()).subtract(line.getDifferenceAmt());
                                    invoiceAmt = invoiceAmt.subtract(line.getDiscountAmt()).subtract(line.getDifferenceAmt()).subtract(overUnder);
                                    if (!invoice.isSOTrx()) {
                                        invoiceAmt = invoiceAmt.negate();
                                    }
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine(invoice + ", Invoice=" + invoiceAmt);
                                    }
                                    totalInvoice = totalInvoice.add(invoiceAmt);
                                }
                                ++i;
                            }
                            if (availableAmt.compareTo(totalInvoice) == 0 && payment.allocateIt()) {
                                String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@PaymentAllocated@ " + payment.getDocumentNo() + " [n]"));
                                this.addLog(0, payment.getDateAcct(), availableAmt, message);
                                ++count;
                            }
                        }
                    }
                }
            }
            ++p;
        }
        return count;
    }

    private int allocateBPOneToOne() throws Exception {
        int count = 0;
        int p = 0;
        while (p < this.m_payments.length) {
            MPayment payment = this.m_payments[p];
            if (!payment.isAllocated()) {
                BigDecimal allocatedAmt = payment.getAllocatedAmt();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(payment + ", Allocated=" + allocatedAmt);
                }
                if (allocatedAmt == null || allocatedAmt.signum() == 0) {
                    BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                    if (!payment.isReceipt()) {
                        availableAmt = availableAmt.negate();
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Available=" + availableAmt);
                    }
                    int i = 0;
                    while (i < this.m_invoices.length) {
                        MInvoice invoice = this.m_invoices[i];
                        if (invoice != null && !invoice.isPaid() && payment.getC_Currency_ID() == invoice.getC_Currency_ID()) {
                            BigDecimal openAmt = invoice.getOpenAmt(true, null);
                            if (!invoice.isSOTrx()) {
                                openAmt = openAmt.negate();
                            }
                            BigDecimal difference = availableAmt.subtract(openAmt).abs();
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(invoice + ", Open=" + openAmt + " - Difference=" + difference);
                            }
                            if (difference.signum() == 0) {
                                Timestamp dateAcct = payment.getDateAcct();
                                if (invoice.getDateAcct().after(dateAcct)) {
                                    dateAcct = invoice.getDateAcct();
                                }
                                if (!this.createAllocation(payment.getC_Currency_ID(), "1:1 (" + availableAmt + ")", dateAcct, availableAmt, null, null, null, invoice.getC_BPartner_ID(), payment.getC_Payment_ID(), invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) {
                                    throw new AdempiereSystemError("Cannot create Allocation");
                                }
                                this.processAllocation();
                                ++count;
                                this.m_invoices[i] = null;
                                this.m_payments[p] = null;
                                payment = null;
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
            ++p;
        }
        return count;
    }

    private int allocateBPartnerAll() throws Exception {
        int C_Currency_ID = MClient.get((Properties)this.getCtx()).getC_Currency_ID();
        Timestamp dateAcct = null;
        BigDecimal totalPayments = Env.ZERO;
        int p = 0;
        while (p < this.m_payments.length) {
            BigDecimal allocatedAmt;
            MPayment payment = this.m_payments[p];
            if (!(payment.isAllocated() || (allocatedAmt = payment.getAllocatedAmt()) != null && allocatedAmt.signum() != 0)) {
                BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                if (!payment.isReceipt()) {
                    availableAmt = availableAmt.negate();
                }
                if (payment.getC_Currency_ID() == C_Currency_ID) {
                    if (dateAcct == null || payment.getDateAcct().after(dateAcct)) {
                        dateAcct = payment.getDateAcct();
                    }
                    totalPayments = totalPayments.add(availableAmt);
                }
            }
            ++p;
        }
        BigDecimal totalInvoices = Env.ZERO;
        int i = 0;
        while (i < this.m_invoices.length) {
            MInvoice invoice = this.m_invoices[i];
            if (!invoice.isPaid()) {
                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                if (!invoice.isSOTrx()) {
                    openAmt = openAmt.negate();
                }
                if (invoice.getC_Currency_ID() == C_Currency_ID) {
                    if (dateAcct == null || invoice.getDateAcct().after(dateAcct)) {
                        dateAcct = invoice.getDateAcct();
                    }
                    totalInvoices = totalInvoices.add(openAmt);
                }
            }
            ++i;
        }
        BigDecimal difference = totalInvoices.subtract(totalPayments);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("= Invoices=" + totalInvoices + " - Payments=" + totalPayments + " = Difference=" + difference);
        }
        if (difference.signum() == 0) {
            int p2 = 0;
            while (p2 < this.m_payments.length) {
                BigDecimal allocatedAmt;
                MPayment payment = this.m_payments[p2];
                if (!(payment.isAllocated() || (allocatedAmt = payment.getAllocatedAmt()) != null && allocatedAmt.signum() != 0)) {
                    BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                    if (!payment.isReceipt()) {
                        availableAmt = availableAmt.negate();
                    }
                    if (payment.getC_Currency_ID() == C_Currency_ID && !this.createAllocation(C_Currency_ID, "BP All", dateAcct, availableAmt, null, null, null, payment.getC_BPartner_ID(), payment.getC_Payment_ID(), 0, payment.getAD_Org_ID())) {
                        throw new AdempiereSystemError("Cannot create Allocation");
                    }
                }
                ++p2;
            }
            int i2 = 0;
            while (i2 < this.m_invoices.length) {
                MInvoice invoice = this.m_invoices[i2];
                if (!invoice.isPaid()) {
                    BigDecimal openAmt = invoice.getOpenAmt(true, null);
                    if (!invoice.isSOTrx()) {
                        openAmt = openAmt.negate();
                    }
                    if (invoice.getC_Currency_ID() == C_Currency_ID && !this.createAllocation(C_Currency_ID, "BP All", dateAcct, openAmt, null, null, null, invoice.getC_BPartner_ID(), 0, invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) {
                        throw new AdempiereSystemError("Cannot create Allocation");
                    }
                }
                ++i2;
            }
            this.processAllocation();
            return 1;
        }
        return 0;
    }

    private int allocateBPOldestFirst() throws Exception {
        BigDecimal diff;
        int C_Currency_ID = MClient.get((Properties)this.getCtx()).getC_Currency_ID();
        Timestamp dateAcct = null;
        BigDecimal totalPayments = Env.ZERO;
        int p = 0;
        while (p < this.m_payments.length) {
            MPayment payment = this.m_payments[p];
            if (!payment.isAllocated() && payment.getC_Currency_ID() == C_Currency_ID) {
                BigDecimal allocatedAmt = payment.getAllocatedAmt();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(payment + ", Allocated=" + allocatedAmt);
                }
                BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                availableAmt = availableAmt.subtract(allocatedAmt);
                if (!payment.isReceipt()) {
                    availableAmt = availableAmt.negate();
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Available=" + availableAmt);
                }
                if (dateAcct == null || payment.getDateAcct().after(dateAcct)) {
                    dateAcct = payment.getDateAcct();
                }
                totalPayments = totalPayments.add(availableAmt);
            }
            ++p;
        }
        BigDecimal totalInvoices = Env.ZERO;
        int i = 0;
        while (i < this.m_invoices.length) {
            MInvoice invoice = this.m_invoices[i];
            if (!invoice.isPaid() && invoice.getC_Currency_ID() == C_Currency_ID) {
                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("" + invoice);
                }
                if (!invoice.isSOTrx()) {
                    openAmt = openAmt.negate();
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Open=" + openAmt);
                }
                if (dateAcct == null || invoice.getDateAcct().after(dateAcct)) {
                    dateAcct = invoice.getDateAcct();
                }
                totalInvoices = totalInvoices.add(openAmt);
            }
            ++i;
        }
        if (totalInvoices.signum() != totalPayments.signum()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Signum - Invoices=" + totalInvoices.signum() + " <> Payments=" + totalPayments.signum());
            }
            return 0;
        }
        BigDecimal difference = totalInvoices.subtract(totalPayments);
        BigDecimal maxAmt = totalInvoices.abs().min(totalPayments.abs());
        if (totalInvoices.signum() < 0) {
            maxAmt = maxAmt.negate();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("= Invoices=" + totalInvoices + " - Payments=" + totalPayments + " = Difference=" + difference + " - Max=" + maxAmt);
        }
        BigDecimal allocatedPayments = Env.ZERO;
        int p2 = 0;
        while (p2 < this.m_payments.length) {
            MPayment payment = this.m_payments[p2];
            if (!payment.isAllocated() && payment.getC_Currency_ID() == C_Currency_ID) {
                BigDecimal allocatedAmt = payment.getAllocatedAmt();
                BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                availableAmt = availableAmt.subtract(allocatedAmt);
                if (!payment.isReceipt()) {
                    availableAmt = availableAmt.negate();
                }
                allocatedPayments = allocatedPayments.add(availableAmt);
                if (totalInvoices.signum() > 0 && allocatedPayments.compareTo(maxAmt) > 0 || totalInvoices.signum() < 0 && allocatedPayments.compareTo(maxAmt) < 0) {
                    diff = allocatedPayments.subtract(maxAmt);
                    availableAmt = availableAmt.subtract(diff);
                    allocatedPayments = allocatedPayments.subtract(diff);
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Payment Allocated=" + availableAmt);
                }
                if (!this.createAllocation(C_Currency_ID, "BP Oldest (" + difference.abs() + ")", dateAcct, availableAmt, null, null, null, payment.getC_BPartner_ID(), payment.getC_Payment_ID(), 0, payment.getAD_Org_ID())) {
                    throw new AdempiereSystemError("Cannot create Allocation");
                }
                if (allocatedPayments.compareTo(maxAmt) == 0) break;
            }
            ++p2;
        }
        BigDecimal allocatedInvoices = Env.ZERO;
        int i2 = 0;
        while (i2 < this.m_invoices.length) {
            MInvoice invoice = this.m_invoices[i2];
            if (!invoice.isPaid() && invoice.getC_Currency_ID() == C_Currency_ID) {
                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                if (!invoice.isSOTrx()) {
                    openAmt = openAmt.negate();
                }
                allocatedInvoices = allocatedInvoices.add(openAmt);
                if (totalInvoices.signum() > 0 && allocatedInvoices.compareTo(maxAmt) > 0 || totalInvoices.signum() < 0 && allocatedInvoices.compareTo(maxAmt) < 0) {
                    diff = allocatedInvoices.subtract(maxAmt);
                    openAmt = openAmt.subtract(diff);
                    allocatedInvoices = allocatedInvoices.subtract(diff);
                }
                if (openAmt.signum() == 0) break;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Invoice Allocated=" + openAmt);
                }
                if (!this.createAllocation(C_Currency_ID, "BP Oldest (" + difference.abs() + ")", dateAcct, openAmt, null, null, null, invoice.getC_BPartner_ID(), 0, invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) {
                    throw new AdempiereSystemError("Cannot create Allocation");
                }
                if (allocatedInvoices.compareTo(maxAmt) == 0) break;
            }
            ++i2;
        }
        if (allocatedPayments.compareTo(allocatedInvoices) != 0) {
            StringBuilder msg = new StringBuilder("Allocated Payments=").append(allocatedPayments).append(" <> Invoices=").append(allocatedInvoices);
            throw new AdempiereSystemError(msg.toString());
        }
        this.processAllocation();
        return 1;
    }

    private boolean createAllocation(int C_Currency_ID, String description, Timestamp dateAcct, BigDecimal Amount, BigDecimal DiscountAmt, BigDecimal WriteOffAmt, BigDecimal OverUnderAmt, int C_BPartner_ID, int C_Payment_ID, int C_Invoice_ID, int AD_Org_ID) {
        if (this.m_allocation != null && this.m_allocation.getC_Currency_ID() != C_Currency_ID) {
            this.processAllocation();
        }
        if (this.m_allocation == null) {
            this.m_allocation = new MAllocationHdr(this.getCtx(), false, dateAcct, C_Currency_ID, "Auto " + description, this.get_TrxName());
            this.m_allocation.setAD_Org_ID(AD_Org_ID);
            if (!this.m_allocation.save()) {
                return false;
            }
        }
        MAllocationLine aLine = new MAllocationLine(this.m_allocation, Amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
        aLine.setC_BPartner_ID(C_BPartner_ID);
        aLine.setC_Payment_ID(C_Payment_ID);
        aLine.setC_Invoice_ID(C_Invoice_ID);
        return aLine.save();
    }

    private boolean processAllocation() {
        if (this.m_allocation == null) {
            return true;
        }
        boolean success = this.m_allocation.processIt("CO");
        if (!success) {
            StringBuilder msg = new StringBuilder("Allocation Process Failed ").append(this.m_allocation.getDocumentNo()).append(" ").append(this.m_allocation.getProcessMsg());
            throw new IllegalStateException(msg.toString());
        }
        this.m_allocation.saveEx();
        String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@AllocationProcessed@ " + this.m_allocation.getDescription()));
        this.addLog(0, this.m_allocation.getDateAcct(), null, message);
        this.m_allocation = null;
        return success;
    }
}

