/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriodControl;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class DocumentTypeVerify
extends SvrProcess {
    private static CLogger s_log = CLogger.getCLogger(DocumentTypeVerify.class);

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        DocumentTypeVerify.createDocumentTypes(this.getCtx(), this.getAD_Client_ID(), this, this.get_TrxName());
        DocumentTypeVerify.createPeriodControls(this.getCtx(), this.getAD_Client_ID(), this, this.get_TrxName());
        return "OK";
    }

    public static void createDocumentTypes(Properties ctx, int AD_Client_ID, SvrProcess sp, String trxName) {
        block11: {
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("AD_Client_ID=" + AD_Client_ID);
            }
            String sql = "SELECT rl.Value, rl.Name FROM AD_Ref_List rl WHERE rl.AD_Reference_ID=183 AND rl.IsActive='Y' AND NOT EXISTS  (SELECT * FROM C_DocType dt WHERE dt.AD_Client_ID=? AND rl.Value=dt.DocBaseType)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MDocType dt;
                        String name = rs.getString(2);
                        String value = rs.getString(1);
                        if (s_log.isLoggable(Level.CONFIG)) {
                            s_log.config(String.valueOf(name) + "=" + value);
                        }
                        if ((dt = new MDocType(ctx, value, name, trxName)).save()) {
                            if (sp != null) {
                                sp.addLog(0, null, null, name);
                                continue;
                            }
                            s_log.fine(name);
                            continue;
                        }
                        if (sp != null) {
                            sp.addLog(0, null, null, "Not created: " + name);
                            continue;
                        }
                        s_log.warning("Not created: " + name);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static void createPeriodControls(Properties ctx, int AD_Client_ID, SvrProcess sp, String trxName) {
        int counter;
        block12: {
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("AD_Client_ID=" + AD_Client_ID);
            }
            String sql = "DELETE C_PeriodControl pc1 WHERE (C_Period_ID, DocBaseType) IN (SELECT C_Period_ID, DocBaseType FROM C_PeriodControl pc2 GROUP BY C_Period_ID, DocBaseType HAVING COUNT(*) > 1) AND C_PeriodControl_ID NOT IN (SELECT MIN(C_PeriodControl_ID) FROM C_PeriodControl pc3 GROUP BY C_Period_ID, DocBaseType)";
            int no = DB.executeUpdate((String)sql, (boolean)false, (String)trxName);
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("Duplicates deleted #" + no);
            }
            sql = "SELECT DISTINCT p.AD_Client_ID, p.C_Period_ID, dt.DocBaseType FROM C_Period p FULL JOIN C_DocType dt ON (p.AD_Client_ID=dt.AD_Client_ID) WHERE p.AD_Client_ID=? AND NOT EXISTS (SELECT * FROM C_PeriodControl pc WHERE pc.C_Period_ID=p.C_Period_ID AND pc.DocBaseType=dt.DocBaseType)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            counter = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPeriodControl pc;
                        int Client_ID = rs.getInt(1);
                        int C_Period_ID = rs.getInt(2);
                        String DocBaseType = rs.getString(3);
                        if (s_log.isLoggable(Level.CONFIG)) {
                            s_log.config("AD_Client_ID=" + Client_ID + ", C_Period_ID=" + C_Period_ID + ", DocBaseType=" + DocBaseType);
                        }
                        if ((pc = new MPeriodControl(ctx, Client_ID, C_Period_ID, DocBaseType, trxName)).save()) {
                            ++counter;
                            if (!s_log.isLoggable(Level.FINE)) continue;
                            s_log.fine(pc.toString());
                            continue;
                        }
                        s_log.warning("Not saved: " + pc);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (sp != null) {
            sp.addLog(0, null, new BigDecimal(counter), "@C_PeriodControl_ID@ @Created@");
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("Inserted #" + counter);
        }
    }
}

