/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.wstore.JSPEnv;

public class Counter
extends HttpServlet
implements Runnable {
    private static final long serialVersionUID = 194411094026644834L;
    private static CLogger log = CLogger.getCLogger(Counter.class);
    public static final String NAME = "counter";
    private List<HttpServletRequest> m_requests = Collections.synchronizedList(new ArrayList());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("Counter.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Counter";
    }

    public void destroy() {
        log.info("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.m_requests.add(request);
        new Thread(this).start();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    public void run() {
        HttpServletRequest request = null;
        if (this.m_requests.size() > 0) {
            request = this.m_requests.remove(0);
        }
        if (request == null) {
            log.log(Level.SEVERE, "Nothing in queue");
            return;
        }
        Properties ctx = JSPEnv.getCtx(request);
        String ref = request.getHeader("referer");
        if (ref == null || ref.length() == 0) {
            ref = request.getRequestURL().toString();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Referer=" + request.getHeader("referer") + " - URL=" + request.getRequestURL());
        }
    }
}

