/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAttachment;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.FileUpload;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class RequestServlet
extends HttpServlet {
    private static final long serialVersionUID = -3070465594678429980L;
    private static CLogger log = CLogger.getCLogger(RequestServlet.class);
    public static final String NAME = "requestServlet";
    public static final String P_FORWARDTO = "ForwardTo";
    public static final String P_SOURCE = "Source";
    public static final String P_INFO = "Info";
    public static final String P_SALESREP_ID = "SalesRep_ID";
    public static final String P_REQUESTTYPE_ID = "RequestType_ID";
    public static final String P_REF_ORDER_ID = "RefOrder_ID";
    public static final String P_CLOSE = "Close";
    public static final String P_ESCALATE = "Escalate";
    public static final String P_SUMMARY = "Summary";
    public static final String P_CONFIDENTIAL = "Confidential";
    public static final String P_REQUEST_ID = "R_Request_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("RequestServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Request Servlet";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        String url = "/requestDetails.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamAttachment(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String streamAttachment(HttpServletRequest request, HttpServletResponse response) {
        Properties ctx;
        MRequest doc;
        int R_Request_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_REQUEST_ID);
        if (R_Request_ID == 0) {
            log.fine("No R_Request_ID)");
            return "No Request ID";
        }
        int attachmentIndex = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_ATTACHMENT_INDEX);
        if (attachmentIndex == 0) {
            log.fine("No index)");
            return "No Request Attachment index";
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("R_Request_ID=" + R_Request_ID + " / " + attachmentIndex);
        }
        if ((doc = new MRequest(ctx = JSPEnv.getCtx(request), R_Request_ID, null)).getR_Request_ID() != R_Request_ID) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Request not found - R_Request_ID=" + R_Request_ID);
            }
            return "Request not found";
        }
        MAttachment attachment = doc.getAttachment(false);
        if (attachment == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No Attachment for R_Request_ID=" + R_Request_ID);
            }
            return "Request Attachment not found";
        }
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getAD_User_ID() != doc.getAD_User_ID() && wu.getAD_User_ID() != doc.getSalesRep_ID()) {
            log.warning("R_Request_ID=" + R_Request_ID + " Web_User=" + wu.getAD_User_ID() + " <> AD_User_ID=" + doc.getAD_User_ID() + " | SalesRep_ID=" + doc.getSalesRep_ID());
            return "Your Request not found";
        }
        return WebUtil.streamAttachment((HttpServletResponse)response, (MAttachment)attachment, (int)attachmentIndex);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String Summary;
        String contentType = request.getContentType();
        if (log.isLoggable(Level.INFO)) {
            log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - " + contentType);
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            log.warning("No web user");
            if (!response.isCommitted()) {
                response.sendRedirect("loginServlet?ForwardTo=request.jsp");
            }
            return;
        }
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.uploadFile(request, response);
            return;
        }
        String requestURL = request.getRequestURL().toString();
        String requestRef = request.getHeader("referer");
        String source = WebUtil.getParameter((HttpServletRequest)request, (String)P_SOURCE);
        String info = WebUtil.getParameter((HttpServletRequest)request, (String)P_INFO);
        String forwardTo = WebUtil.getParameter((HttpServletRequest)request, (String)P_FORWARDTO);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Referer=" + requestRef + ", Source=" + source + ", ForwardTo=" + forwardTo);
        }
        if (requestURL == null) {
            requestURL = "";
        }
        if (requestURL.equals(requestRef)) {
            requestRef = source;
            source = null;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (String)"AD_Client_ID");
        int R_RequestType_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_REQUESTTYPE_ID);
        int C_Order_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_REF_ORDER_ID);
        int R_Request_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_REQUEST_ID);
        int SalesRep_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_SALESREP_ID);
        if (SalesRep_ID != 0 && !MUser.isSalesRep((int)SalesRep_ID)) {
            log.warning("Invalid (set to 0) SalesRep_ID=" + SalesRep_ID);
            SalesRep_ID = 0;
        }
        if ((Summary = WebUtil.getParameter((HttpServletRequest)request, (String)P_SUMMARY)) == null || Summary.length() == 0) {
            WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"No Data Received");
            return;
        }
        boolean IsConfidential = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)P_CONFIDENTIAL);
        boolean IsClose = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)P_CLOSE);
        boolean IsEscalate = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)P_ESCALATE);
        MRequest req = null;
        if (R_Request_ID == 0) {
            req = new MRequest(ctx, SalesRep_ID, R_RequestType_ID, Summary, true, null);
            req.setC_BPartner_ID(wu.getC_BPartner_ID());
            req.setAD_User_ID(wu.getAD_User_ID());
            if (C_Order_ID > 0) {
                req.setC_Order_ID(C_Order_ID);
            }
            if (IsConfidential) {
                req.setConfidentialType("C");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("From:").append(request.getRemoteHost()).append("-").append(request.getRemoteAddr());
            sb.append(", Request:").append(requestURL).append("-").append(requestRef);
            if (source != null) {
                sb.append("-").append(source);
            }
            sb.append("-").append(info);
            sb.append(", User=").append(request.getHeader("accept-language")).append("-").append(request.getHeader("user-agent"));
            req.setLastResult(sb.toString());
            if (!req.save()) {
                log.log(Level.SEVERE, "New Request NOT saved");
                WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"Request Save Error. Shorten Text!");
                return;
            }
        } else {
            req = new MRequest(ctx, R_Request_ID, null);
            if (req.get_ID() == 0) {
                log.log(Level.SEVERE, "Request NOT found - R_Request_ID=" + R_Request_ID);
                WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"Request Not found.");
                return;
            }
            if (C_Order_ID != 0 && req.getC_Order_ID() == 0) {
                req.setC_Order_ID(C_Order_ID);
            }
            if (!req.webUpdate(Summary)) {
                WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"Request Cannot be updated.");
                return;
            }
            if (IsConfidential) {
                req.setConfidentialTypeEntry("C");
            }
            if (IsClose) {
                req.doClose();
            } else if (IsEscalate) {
                boolean isUser;
                boolean bl = isUser = req.getC_BPartner_ID() == wu.getC_BPartner_ID();
                if (isUser || wu.isSalesRep()) {
                    req.doEscalate(isUser);
                }
            }
            if (!req.save()) {
                log.log(Level.SEVERE, "Request Action Error");
                WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"Request Process Error.");
                return;
            }
        }
        StringBuffer message = new StringBuffer(req.getSummary());
        String result = req.getResult();
        if (result != null && result.length() > 0) {
            message.append("\n----------\n").append(req.getResult());
        }
        JSPEnv.sendEMail(request, wu, "WR", new Object[]{req.getDocumentNo(), wu.getName(), message, "\n---------- " + req.getMailTag()});
        String webStoreURL = "http://" + request.getServerName() + request.getContextPath() + "/";
        if (forwardTo == null || forwardTo.length() == 0) {
            forwardTo = requestRef;
        }
        if (forwardTo != null && (forwardTo.indexOf("request.jsp") != -1 || forwardTo.indexOf("requestDetails.jsp") != -1)) {
            forwardTo = "requests.jsp";
        }
        if (forwardTo == null || forwardTo.length() == 0) {
            forwardTo = webStoreURL;
        }
        if (forwardTo.indexOf("Servlet") != -1) {
            forwardTo = webStoreURL;
        }
        WebUtil.createForwardPage((HttpServletResponse)response, (String)"Web Request Received - Thanks", (String)forwardTo, (int)10);
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileUpload upload = new FileUpload(request);
        String error = upload.getError();
        if (error != null) {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)error, (String)"requests.jsp", (int)10);
            return;
        }
        Properties ctx = JSPEnv.getCtx(request);
        int R_Request_ID = upload.getParameterAsInt(P_REQUEST_ID);
        MRequest req = null;
        if (R_Request_ID != 0) {
            req = new MRequest(ctx, R_Request_ID, null);
        }
        if (R_Request_ID == 0 || req == null || req.get_ID() != R_Request_ID) {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"Request not found", (String)"requests.jsp", (int)10);
            return;
        }
        if (!req.isWebCanUpdate()) {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"Request cannot be updated", (String)"requests.jsp", (int)10);
            return;
        }
        String fileName = upload.getFileName();
        if (log.isLoggable(Level.FINE)) {
            log.fine("R_Request_ID=" + R_Request_ID + " - " + fileName);
        }
        MAttachment attachment = req.createAttachment();
        attachment.addEntry(fileName, upload.getData());
        if (attachment.save()) {
            String msg = Msg.parseTranslation((Properties)ctx, (String)("@Added@: @AD_Attachment_ID@ " + fileName));
            req.webUpdate(msg);
            req.saveEx();
            WebUtil.createForwardPage((HttpServletResponse)response, (String)msg, (String)"requests.jsp", (int)10);
        } else {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"File Upload Error - Please try again", (String)"requests.jsp", (int)10);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(attachment.toString());
        }
    }
}

