/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MOrg;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class SearchServlet
extends HttpServlet {
    private static final long serialVersionUID = -3716389906162825762L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("SearchServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Search Servlet";
    }

    public void destroy() {
        this.log.info("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        HttpSession session = request.getSession(true);
        Properties ctx = JSPEnv.getCtx(request);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/xml; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        int expenseID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"W_Expense_ID");
        int clientID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"clientID");
        int campaignID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"campaignID");
        int projectID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"projectID");
        int phaseID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"phaseID");
        int taskID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"taskID");
        int orgID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"orgID");
        int warehouseID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"warehouseID");
        int partnerID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"partnerID");
        String get = Util.maskHTML((String)request.getParameter("get"), (boolean)true);
        if (get == null) {
            out.println("<error>Unknown Request: NULL</error>");
        } else if (get.equalsIgnoreCase("clientList")) {
            this.outputClients(ctx, out, clientID, expenseID == 0);
        } else if (get.equalsIgnoreCase("orgList")) {
            this.outputOrgs(ctx, out, clientID, orgID, expenseID == 0);
        } else if (get.equalsIgnoreCase("campaignList")) {
            this.outputCampaigns(ctx, out, campaignID, expenseID == 0);
        } else if (get.equalsIgnoreCase("projectList")) {
            this.outputProjects(ctx, out, projectID, expenseID == 0);
        } else if (get.equalsIgnoreCase("phaseList")) {
            this.outputPhases(ctx, out, projectID, phaseID, expenseID == 0);
        } else if (get.equalsIgnoreCase("taskList")) {
            this.outputTasks(ctx, out, projectID, phaseID, taskID, expenseID == 0);
        } else if (get.equalsIgnoreCase("partnerList")) {
            this.outputPartners(ctx, out, partnerID, expenseID == 0);
        } else if (get.equalsIgnoreCase("warehouseList")) {
            this.outputWarehouses(ctx, out, orgID, warehouseID, expenseID == 0);
        } else if (get.equalsIgnoreCase("priceList")) {
            this.outputPriceLists(ctx, out, expenseID == 0);
        } else {
            out.println("<error>Unknown Request: " + get + "</error>");
        }
        out.flush();
        out.close();
    }

    private void outputCampaigns(Properties ctx, PrintWriter out, int campaignID, boolean includeAny) {
        out.println("<campaigns>");
        if (includeAny) {
            out.println("<campaign id='-1'");
            if (campaignID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</campaign>");
        }
        out.println("<campaign id='1'>Rose Festival</campaign>");
        out.println("</campaigns>");
    }

    private void outputProjects(Properties ctx, PrintWriter out, int projectID, boolean includeAny) {
        out.println("<projects>");
        if (includeAny) {
            out.println("<project id='-1'");
            if (projectID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</project>");
        }
        out.println("<project id='1'>Landscaping New Office</project>");
        out.println("</projects>");
    }

    private void outputPhases(Properties ctx, PrintWriter out, int projectID, int phaseID, boolean includeAny) {
        out.println("<phases projectID='" + projectID + "'>");
        if (includeAny) {
            out.println("<phase id='-1'");
            if (phaseID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</phase>");
        }
        if (projectID == 1) {
            out.println("<phase id='1'>Planning</phase>");
        }
        out.println("</phases>");
    }

    private void outputTasks(Properties ctx, PrintWriter out, int projectID, int phaseID, int taskID, boolean includeAny) {
        out.println("<tasks projectID='" + projectID + "' phaseID='" + phaseID + "'>");
        if (includeAny) {
            out.println("<task id='-1'");
            if (taskID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</task>");
        }
        if (projectID == 1 && phaseID == 1) {
            out.println("<task id='1'>Call Owner</task>");
        }
        out.println("</tasks>");
    }

    private void outputPartners(Properties ctx, PrintWriter out, int partnerID, boolean includeAny) {
        out.println("<partners>");
        if (includeAny) {
            out.println("<partner id='-1'");
            if (partnerID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</partner>");
        }
        MBPartner[] mBPartnerArray = this.getAllPartners(ctx);
        int n = mBPartnerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBPartner partner = mBPartnerArray[n2];
            out.print("<partner id='" + partner.get_ID() + "'");
            if (partnerID == partner.get_ID()) {
                out.print(" selected='selected'");
            }
            out.println(">" + Util.maskHTML((String)partner.getName()) + "</partner>");
            ++n2;
        }
        out.println("</partners>");
    }

    private void outputWarehouses(Properties ctx, PrintWriter out, int orgID, int warehouseID, boolean includeAny) {
        out.println("<warehouses orgID='" + orgID + "'>");
        if (includeAny) {
            out.println("<warehouse id='-1'");
            if (warehouseID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</warehouse>");
        }
        MWarehouse[] mWarehouseArray = MWarehouse.getForOrg((Properties)ctx, (int)orgID);
        int n = mWarehouseArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWarehouse warehouse = mWarehouseArray[n2];
            out.print("<warehouse id='" + warehouse.getM_Warehouse_ID() + "'");
            if (warehouseID == warehouse.getM_Warehouse_ID()) {
                out.print(" selected='selected'");
            }
            out.println(">" + Util.maskHTML((String)warehouse.getName()) + "</warehouse>");
            ++n2;
        }
        out.println("</warehouses>");
    }

    private void outputPriceLists(Properties ctx, PrintWriter out, boolean includeAny) {
        out.println("<pricelists>");
        if (includeAny) {
            out.println("<pricelist id='-1' selected='selected'>ANY</pricelist>");
        }
        out.println("<pricelist id='1'>Standard</pricelist>");
        out.println("<pricelist id='2'>Summer Specials</pricelist>");
        out.println("</pricelists>");
    }

    private void outputClients(Properties ctx, PrintWriter out, int clientID, boolean includeAny) {
        out.println("<clients>");
        if (includeAny) {
            out.println("<client id='-1'");
            if (clientID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</client>");
        }
        MClient[] mClientArray = MClient.getAll((Properties)ctx);
        int n = mClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            MClient client = mClientArray[n2];
            out.print("<client id='" + client.getAD_Client_ID() + "'");
            if (clientID == client.getAD_Client_ID()) {
                out.print(" selected='selected'");
            }
            out.println(">" + Util.maskHTML((String)client.getName()) + "</client>");
            ++n2;
        }
        out.println("</clients>");
    }

    private void outputOrgs(Properties ctx, PrintWriter out, int clientID, int orgID, boolean includeAny) {
        MClient client = MClient.get((Properties)ctx, (int)clientID);
        out.println("<orgs clientID='" + clientID + "'>");
        if (includeAny) {
            out.println("<org id='-1'");
            if (clientID == 0) {
                out.println(" selected='selected'");
            }
            out.println(">ANY</org>");
        }
        if (client != null) {
            MOrg[] mOrgArray = MOrg.getOfClient((PO)client);
            int n = mOrgArray.length;
            int n2 = 0;
            while (n2 < n) {
                MOrg org = mOrgArray[n2];
                out.print("<org id='" + org.getAD_Org_ID() + "'");
                if (orgID == org.getAD_Org_ID()) {
                    out.print(" selected='selected'");
                }
                out.println(">" + Util.maskHTML((String)org.getName()) + "</org>");
                ++n2;
            }
        }
        out.println("</orgs>");
    }

    private MBPartner[] getAllPartners(Properties ctx) {
        ArrayList<MBPartner> list;
        block6: {
            list = new ArrayList<MBPartner>();
            String sql = "SELECT * FROM C_BPartner";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MBPartner partner = new MBPartner(ctx, rs, null);
                        list.add(partner);
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MBPartner[] retValue = new MBPartner[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

