/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;

public class CvsVersion
extends AbstractCvsTask {
    static final long VERSION_1_11_2 = 11102L;
    static final long MULTIPLY = 100L;
    private String clientVersion;
    private String serverVersion;
    private String clientVersionProperty;
    private String serverVersionProperty;

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setClientVersionProperty(String clientVersionProperty) {
        this.clientVersionProperty = clientVersionProperty;
    }

    public void setServerVersionProperty(String serverVersionProperty) {
        this.serverVersionProperty = serverVersionProperty;
    }

    public boolean supportsCvsLogWithSOption() {
        if (this.serverVersion == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.serverVersion, ".");
        long counter = 10000L;
        long version = 0L;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            int i = 0;
            for (i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            }
            String s2 = s.substring(0, i);
            version += counter * Long.parseLong(s2);
            if (counter == 1L) break;
            counter /= 100L;
        }
        return version >= 11102L;
    }

    public void execute() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.setOutputStream(bos);
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        this.setErrorStream(berr);
        this.setCommand("version");
        super.execute();
        String output = bos.toString();
        StringTokenizer st = new StringTokenizer(output);
        boolean client = false;
        boolean server = false;
        boolean cvs = false;
        while (st.hasMoreTokens()) {
            String currentToken = st.nextToken();
            if (currentToken.equals("Client:")) {
                client = true;
            } else if (currentToken.equals("Server:")) {
                server = true;
            } else if (currentToken.equals("(CVS)")) {
                cvs = true;
            }
            if (client && cvs) {
                if (st.hasMoreTokens()) {
                    this.clientVersion = st.nextToken();
                }
                client = false;
                cvs = false;
                continue;
            }
            if (!server || !cvs) continue;
            if (st.hasMoreTokens()) {
                this.serverVersion = st.nextToken();
            }
            server = false;
            cvs = false;
        }
        if (this.clientVersionProperty != null) {
            this.getProject().setNewProperty(this.clientVersionProperty, this.clientVersion);
        }
        if (this.serverVersionProperty != null) {
            this.getProject().setNewProperty(this.serverVersionProperty, this.serverVersion);
        }
    }
}

