/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingCommand;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingData;
import net.sf.jasperreports.components.headertoolbar.actions.FormatCondition;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class ConditionalFormattingAction
extends AbstractVerifiableTableAction {
    public ConditionalFormattingData getConditionalFormattingData() {
        return (ConditionalFormattingData)this.columnData;
    }

    public void setConditionalFormattingData(ConditionalFormattingData conditionalFormattingData) {
        this.columnData = conditionalFormattingData;
    }

    @Override
    public void performAction() throws ActionException {
        try {
            this.getCommandStack().execute(new ResetInCacheCommand(new ConditionalFormattingCommand(this.getJasperReportsContext(), this.table, this.getConditionalFormattingData()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e) {
            throw new ActionException(e.getMessage());
        }
    }

    @Override
    public void verify() throws ActionException {
        ConditionalFormattingData cfd = this.getConditionalFormattingData();
        List<FormatCondition> conditions = cfd.getConditions();
        if (conditions.size() > 0) {
            FilterTypesEnum conditionType = FilterTypesEnum.getByName(cfd.getConditionType());
            Locale locale = (Locale)this.getReportContext().getParameterValue("REPORT_LOCALE");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int ln = conditions.size();
            for (int i = 0; i < ln; ++i) {
                FormatCondition condition = conditions.get(i);
                if (conditionType == FilterTypesEnum.DATE) {
                    FilterTypeDateOperatorsEnum dateEnum = FilterTypeDateOperatorsEnum.getByEnumConstantName(condition.getConditionTypeOperator());
                    boolean containsBetween = FilterTypeDateOperatorsEnum.IS_BETWEEN.equals(dateEnum) || FilterTypeDateOperatorsEnum.IS_NOT_BETWEEN.equals(dateEnum);
                    try {
                        DateFormat df = formatFactory.createDateFormat(cfd.getConditionPattern(), locale, null);
                        df.setLenient(false);
                        if (containsBetween) {
                            if (condition.getConditionStart() == null || condition.getConditionStart().length() == 0) {
                                this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.start.date", i + 1);
                            } else {
                                try {
                                    df.parse(condition.getConditionStart());
                                }
                                catch (ParseException e) {
                                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.start.date", i + 1, condition.getConditionStart());
                                }
                            }
                            if (condition.getConditionEnd() != null && condition.getConditionEnd().length() > 0) {
                                try {
                                    df.parse(condition.getConditionEnd());
                                }
                                catch (ParseException e) {
                                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.end.date", i + 1, condition.getConditionEnd());
                                }
                                continue;
                            }
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.end.date", i + 1);
                            continue;
                        }
                        if (condition.getConditionStart() == null || condition.getConditionStart().length() == 0) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.date", i + 1);
                            continue;
                        }
                        try {
                            df.parse(condition.getConditionStart());
                        }
                        catch (ParseException e) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.date", i + 1, condition.getConditionStart());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.pattern", i + 1);
                    }
                    continue;
                }
                if (conditionType != FilterTypesEnum.NUMERIC) continue;
                if (condition.getConditionStart() == null || condition.getConditionStart().trim().length() == 0) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.number", i + 1);
                    continue;
                }
                try {
                    NumberFormat nf = this.createNumberFormat(cfd.getConditionPattern(), locale);
                    nf.parse(condition.getConditionStart());
                    if (condition.getConditionEnd() == null || condition.getConditionEnd().length() <= 0) continue;
                    try {
                        nf.parse(condition.getConditionEnd());
                    }
                    catch (ParseException e) {
                        this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.number", i + 1, condition.getConditionEnd());
                    }
                    continue;
                }
                catch (ParseException e) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.number", i + 1, condition.getConditionStart());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.pattern", i + 1);
                }
            }
        }
    }
}

