/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConduitBridge
extends DemandForwardingBridge {
    private static final Log LOG = LogFactory.getLog(ConduitBridge.class);

    public ConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected boolean checkPaths(BrokerId[] first, BrokerId[] second) {
        if (first == null || second == null) {
            return true;
        }
        if (Arrays.equals(first, second)) {
            return true;
        }
        return !first[0].equals(second[0]) || !first[first.length - 1].equals(second[second.length - 1]);
    }

    protected boolean addToAlreadyInterestedConsumers(ConsumerInfo info) {
        boolean matched = false;
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            DestinationFilter filter = DestinationFilter.parseFilter(ds.getLocalInfo().getDestination());
            if (!filter.matches(info.getDestination())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.configuration.getBrokerName() + " matched (add interest) to exsting sub for: " + ds.getRemoteInfo() + " with sub: " + info));
            }
            if (this.checkPaths(info.getBrokerPath(), ds.getRemoteInfo().getBrokerPath())) {
                ds.add(info.getConsumerId());
            }
            matched = true;
        }
        return matched;
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        ArrayList<DemandSubscription> tmpList = new ArrayList<DemandSubscription>();
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (ds.remove(id) && LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.configuration.getBrokerName() + " removing interest in sub on " + this.localBroker + " from " + this.remoteBrokerName + " : sub: " + id + " existing matched sub: " + ds.getRemoteInfo()));
            }
            if (!ds.isEmpty()) continue;
            tmpList.add(ds);
        }
        for (DemandSubscription ds : tmpList) {
            this.removeSubscription(ds);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(this.configuration.getBrokerName() + " removing sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + ds.getRemoteInfo()));
        }
    }
}

