/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MBankStatementMatcher;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class BankStatementMatcher
extends SvrProcess {
    MBankStatementMatcher[] m_matchers = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_matchers = MBankStatementMatcher.getMatchers((Properties)this.getCtx(), (String)this.get_TrxName());
    }

    protected String doIt() throws Exception {
        int Table_ID = this.getTable_ID();
        int Record_ID = this.getRecord_ID();
        if (this.m_matchers == null || this.m_matchers.length == 0) {
            throw new IllegalStateException("No Matchers found");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - Table_ID=" + Table_ID + ", Record_ID=" + Record_ID + ", Matchers=" + this.m_matchers.length);
        }
        if (Table_ID == 600) {
            return this.match(new X_I_BankStatement(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        if (Table_ID == 392) {
            return this.match(new MBankStatement(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        if (Table_ID == 393) {
            return this.match(new MBankStatementLine(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        return "??";
    }

    private String match(X_I_BankStatement ibs) {
        if (this.m_matchers == null || ibs == null || ibs.getC_Payment_ID() != 0) {
            return "--";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("" + ibs);
        }
        BankStatementMatchInfo info = null;
        int i = 0;
        while (i < this.m_matchers.length) {
            if (this.m_matchers[i].isMatcherValid() && (info = this.m_matchers[i].getMatcher().findMatch(ibs)) != null && info.isMatched()) {
                if (info.getC_Payment_ID() > 0) {
                    ibs.setC_Payment_ID(info.getC_Payment_ID());
                }
                if (info.getC_Invoice_ID() > 0) {
                    ibs.setC_Invoice_ID(info.getC_Invoice_ID());
                }
                if (info.getC_BPartner_ID() > 0) {
                    ibs.setC_BPartner_ID(info.getC_BPartner_ID());
                }
                ibs.saveEx();
                return "OK";
            }
            ++i;
        }
        return "--";
    }

    private String match(MBankStatementLine bsl) {
        if (this.m_matchers == null || bsl == null || bsl.getC_Payment_ID() != 0) {
            return "--";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("match - " + bsl);
        }
        BankStatementMatchInfo info = null;
        int i = 0;
        while (i < this.m_matchers.length) {
            if (this.m_matchers[i].isMatcherValid() && (info = this.m_matchers[i].getMatcher().findMatch(bsl)) != null && info.isMatched()) {
                if (info.getC_Payment_ID() > 0) {
                    bsl.setC_Payment_ID(info.getC_Payment_ID());
                }
                if (info.getC_Invoice_ID() > 0) {
                    bsl.setC_Invoice_ID(info.getC_Invoice_ID());
                }
                if (info.getC_BPartner_ID() > 0) {
                    bsl.setC_BPartner_ID(info.getC_BPartner_ID());
                }
                bsl.saveEx();
                return "OK";
            }
            ++i;
        }
        return "--";
    }

    private String match(MBankStatement bs) {
        if (this.m_matchers == null || bs == null) {
            return "--";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("match - " + bs);
        }
        int count = 0;
        MBankStatementLine[] lines = bs.getLines(false);
        int i = 0;
        while (i < lines.length) {
            if (lines[i].getC_Payment_ID() == 0) {
                this.match(lines[i]);
                ++count;
            }
            ++i;
        }
        return String.valueOf(count);
    }
}

