/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.X_I_InOutLineConfirm;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportInOutConfirm
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_DeleteOldImported = false;
    private int p_I_InOutLineConfirm_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOldImported")) {
                    this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_I_InOutLineConfirm_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int no;
        block15: {
            StringBuilder msglog = new StringBuilder("I_InOutLineConfirm_ID=").append(this.p_I_InOutLineConfirm_ID);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(msglog.toString());
            }
            StringBuilder sql = null;
            no = 0;
            StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
            if (this.p_DeleteOldImported) {
                sql = new StringBuilder("DELETE I_InOutLineConfirm ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            sql = new StringBuilder("UPDATE I_InOutLineConfirm ").append("SET IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Reset=" + no);
            }
            sql = new StringBuilder("UPDATE I_InOutLineConfirm i ").append("SET AD_Client_ID=COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append(") ").append("WHERE (AD_Client_ID IS NULL OR AD_Client_ID=0)").append(" AND I_IsImported<>'Y'");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Client from Value=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_InOutLineConfirm i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Confirmation Line, '").append("WHERE (M_InOutLineConfirm_ID IS NULL OR M_InOutLineConfirm_ID=0").append(" OR NOT EXISTS (SELECT * FROM M_InOutLineConfirm c WHERE i.M_InOutLineConfirm_ID=c.M_InOutLineConfirm_ID))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid InOutLineConfirm=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_InOutLineConfirm i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Missing Confirmation No, '").append("WHERE (ConfirmationNo IS NULL OR ConfirmationNo='')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid ConfirmationNo=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_InOutLineConfirm i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Target<>(Confirmed+Difference+Scrapped), ' ").append("WHERE EXISTS (SELECT * FROM M_InOutLineConfirm c ").append("WHERE i.M_InOutLineConfirm_ID=c.M_InOutLineConfirm_ID").append(" AND c.TargetQty<>(i.ConfirmedQty+i.ScrappedQty+i.DifferenceQty))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Qty=" + no);
            }
            this.commitEx();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            sql = new StringBuilder("SELECT * FROM I_InOutLineConfirm ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY I_InOutLineConfirm_ID");
            no = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_I_InOutLineConfirm importLine = new X_I_InOutLineConfirm(this.getCtx(), rs, this.get_TrxName());
                        MInOutLineConfirm confirmLine = new MInOutLineConfirm(this.getCtx(), importLine.getM_InOutLineConfirm_ID(), this.get_TrxName());
                        if (confirmLine.get_ID() == 0 || confirmLine.get_ID() != importLine.getM_InOutLineConfirm_ID()) {
                            importLine.setI_IsImported(false);
                            importLine.setI_ErrorMsg("ID Not Found");
                            importLine.saveEx();
                            continue;
                        }
                        confirmLine.setConfirmationNo(importLine.getConfirmationNo());
                        confirmLine.setConfirmedQty(importLine.getConfirmedQty());
                        confirmLine.setDifferenceQty(importLine.getDifferenceQty());
                        confirmLine.setScrappedQty(importLine.getScrappedQty());
                        confirmLine.setDescription(importLine.getDescription());
                        if (!confirmLine.save()) continue;
                        importLine.setI_IsImported(true);
                        importLine.setProcessed(true);
                        if (!importLine.save()) continue;
                        ++no;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Updated@ #").append(no);
        return msgreturn.toString();
    }
}

