/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.client;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.restlet.ext.ssl.DefaultSslContextFactory;

public class ClientSSLContextFactory
extends DefaultSslContextFactory {
    private volatile String keyManagerAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
    private volatile char[] keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")) != null ? System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")).toCharArray() : null;
    private volatile char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword") != null ? System.getProperty("javax.net.ssl.keyStorePassword").toCharArray() : null;
    private volatile String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private volatile String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
    private volatile String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
    private volatile String secureRandomAlgorithm = null;
    private volatile String secureSocketProtocol = "TLS";
    private volatile String trustManagerAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
    private volatile char[] trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword").toCharArray() : null;
    private volatile String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private volatile String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private volatile String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");

    public SSLContext createSslContext() throws Exception {
        KeyManagerFactory kmf = null;
        if (this.keyStorePath != null || this.keyStoreProvider != null || this.keyStoreType != null) {
            KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = this.keyStorePath != null && !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                keyStore.load(keyStoreInputStream, this.keyStorePassword);
            }
            finally {
                if (keyStoreInputStream != null) {
                    keyStoreInputStream.close();
                }
            }
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            kmf.init(keyStore, this.keyStoreKeyPassword);
        }
        TrustManagerFactory tmf = null;
        if (this.trustStorePath != null || this.trustStoreProvider != null || this.trustStoreType != null) {
            KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
            FileInputStream trustStoreInputStream = null;
            try {
                trustStoreInputStream = this.trustStorePath != null && !"NONE".equals(this.trustStorePath) ? new FileInputStream(this.trustStorePath) : null;
                trustStore.load(trustStoreInputStream, this.trustStorePassword);
            }
            finally {
                if (trustStoreInputStream != null) {
                    trustStoreInputStream.close();
                }
            }
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            tmf.init(trustStore);
        }
        TrustManager[] trustManagers = null;
        trustManagers = tmf != null ? tmf.getTrustManagers() : new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance(this.secureSocketProtocol);
        SecureRandom sr = null;
        if (this.secureRandomAlgorithm != null) {
            sr = SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, trustManagers, sr);
        return sslContext;
    }
}

