/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.adempiere.model.ZoomInfoFactory;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class AZoomAcross {
    private final JPopupMenu m_popup = new JPopupMenu("ZoomMenu");
    private static final CLogger logger = CLogger.getCLogger(AZoomAcross.class);
    private final List<ZoomInfoFactory.ZoomInfo> zoomInfos = new ArrayList<ZoomInfoFactory.ZoomInfo>();

    public AZoomAcross(JComponent invoker, String tableName, int windowID, MQuery query) {
        this(invoker, new Query(Env.getCtx(), tableName, query.getWhereClause(), null).first(), windowID);
    }

    public AZoomAcross(JComponent invoker, PO po, int windowID) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("PO=" + po + ", WindowID=" + windowID);
        }
        this.mkZoomTargets(po, windowID);
        for (final ZoomInfoFactory.ZoomInfo zoomInfo : this.zoomInfos) {
            String label = String.valueOf(zoomInfo.destinationDisplay) + " (#" + zoomInfo.query.getRecordCount() + ")";
            this.m_popup.add(label).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AZoomAcross.this.launchZoom(zoomInfo);
                }
            });
        }
        if (this.zoomInfos.isEmpty()) {
            this.m_popup.add(Msg.getMsg((Properties)Env.getCtx(), (String)"NoZoomTarget"));
        }
        if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    private void mkZoomTargets(PO po, int windowID) {
        for (ZoomInfoFactory.ZoomInfo zoomInfo : ZoomInfoFactory.retrieveZoomInfos((PO)po, (int)windowID)) {
            if (zoomInfo.query.getRecordCount() == 0) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("No target records for destination " + zoomInfo.destinationDisplay);
                continue;
            }
            this.zoomInfos.add(zoomInfo);
        }
    }

    private void launchZoom(ZoomInfoFactory.ZoomInfo zoomInfo) {
        AWindow frame;
        int AD_Window_ID = zoomInfo.windowId;
        MQuery query = zoomInfo.query;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("AD_Window_ID=" + AD_Window_ID + " - " + query);
        }
        if (!(frame = new AWindow(null)).initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }
}

