/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Insets;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.search.Find;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.ValueNamePair;

public final class FindValueRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 5290173817551899865L;
    private Find m_find;
    private boolean m_valueToColumn;
    private boolean m_between = false;
    private volatile String m_columnName = null;
    private JCheckBox m_check = null;
    private static CLogger log = CLogger.getCLogger(FindValueRenderer.class);

    public FindValueRenderer(Find find, boolean valueTo) {
        this.m_find = find;
        this.m_valueToColumn = valueTo;
    }

    private JCheckBox getCheck() {
        if (this.m_check == null) {
            this.m_check = new JCheckBox();
            this.m_check.setMargin(new Insets(0, 0, 0, 0));
            this.m_check.setHorizontalAlignment(0);
        }
        return this.m_check;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        boolean enabled;
        this.m_columnName = null;
        Object column = table.getModel().getValueAt(row, 2);
        if (column != null) {
            this.m_columnName = column instanceof ValueNamePair ? ((ValueNamePair)column).getValue() : column.toString();
        }
        this.m_between = false;
        Object betweenValue = table.getModel().getValueAt(row, 3);
        if (this.m_valueToColumn && betweenValue != null && betweenValue.equals(MQuery.OPERATORS[8])) {
            this.m_between = true;
        }
        boolean bl = enabled = !this.m_valueToColumn || this.m_valueToColumn && this.m_between;
        if (enabled) {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value == null || this.m_valueToColumn && !this.m_between) {
            return c;
        }
        GridField field = this.getMField();
        if (field != null && field.getDisplayType() == 20) {
            JCheckBox cb = this.getCheck();
            if (value instanceof Boolean) {
                cb.setSelected((Boolean)value);
            } else {
                cb.setSelected(value.toString().indexOf(89) != -1);
            }
            return cb;
        }
        return c;
    }

    @Override
    protected void setValue(Object value) {
        String str;
        boolean enabled;
        boolean bl = enabled = !this.m_valueToColumn || this.m_valueToColumn && this.m_between;
        if (value == null || !enabled) {
            super.setValue(null);
            return;
        }
        String retValue = null;
        if (value != null && (str = value.toString()).startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
            value = str;
        }
        int displayType = 0;
        GridField field = this.getMField();
        if (field != null) {
            displayType = field.getDisplayType();
        } else {
            log.log(Level.SEVERE, "FindValueRenderer.setValue (" + value + ") ColumnName=" + this.m_columnName + " No Target Column");
        }
        this.setHorizontalAlignment(2);
        if (DisplayType.isNumeric((int)displayType)) {
            this.setHorizontalAlignment(4);
            retValue = DisplayType.getNumberFormat((int)displayType).format(value);
        } else if (DisplayType.isDate((int)displayType)) {
            if (value instanceof java.sql.Date) {
                retValue = DisplayType.getDateFormat((int)displayType).format(value);
                this.setHorizontalAlignment(4);
            } else if (value instanceof String) {
                try {
                    Date date = DisplayType.getDateFormat_JDBC().parse((String)value);
                    retValue = DisplayType.getDateFormat((int)displayType).format(date);
                    this.setHorizontalAlignment(4);
                }
                catch (Exception e) {
                    retValue = value.toString();
                }
            } else {
                retValue = value.toString();
            }
        } else if (displayType == 26) {
            retValue = "";
        } else if (DisplayType.isLookup((int)displayType) && field != null) {
            Lookup lookup = field.getLookup();
            if (lookup != null) {
                retValue = lookup.getDisplay(value);
            }
        } else {
            super.setValue(value);
            return;
        }
        super.setValue(retValue);
    }

    private GridField getMField() {
        return this.m_find.getTargetMField(this.m_columnName);
    }
}

