/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoAssignment
extends Info {
    private static final long serialVersionUID = 5017170699571459745L;
    private CLabel labelResourceType = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"S_ResourceType_ID"));
    private VLookup fieldResourceType;
    private CLabel labelResource = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
    private VLookup fieldResource;
    private CLabel labelFrom = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private VDate fieldFrom = new VDate(15);
    private CLabel labelTo = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private VDate fieldTo = new VDate(15);
    private CButton bNew = new CButton();
    private static String s_assignmentFROM = "S_ResourceAssignment ra, S_ResourceType rt, S_Resource r, C_UOM uom";
    private static String s_assignmentWHERE = "ra.IsActive='Y' AND ra.S_Resource_ID=r.S_Resource_ID AND r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID";
    private static Info_Column[] s_assignmentLayout = new Info_Column[]{new Info_Column(" ", "ra.S_ResourceAssignment_ID", IDColumn.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"S_ResourceType_ID"), "rt.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"), "r.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"AssignDateFrom"), "ra.AssignDateFrom", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Qty"), "ra.Qty", Double.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"), "uom.UOMSymbol", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"AssignDateTo"), "ra.AssignDateTo", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsConfirmed"), "ra.IsConfirmed", Boolean.class)};

    public InfoAssignment(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, value, multiSelection, whereClause, true);
    }

    public InfoAssignment(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause, boolean lookup) {
        super(frame, modal, WindowNo, "ra", "S_ResourceAssigment_ID", multiSelection, whereClause, lookup);
        this.log.info(value);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoAssignment"));
        if (!this.initLookups()) {
            return;
        }
        this.statInit();
        this.initInfo(value, whereClause);
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private boolean initLookups() {
        try {
            int AD_Column_ID = 6851;
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
            this.fieldResourceType = new VLookup("S_ResourceType_ID", false, false, true, (Lookup)lookup);
            AD_Column_ID = 6826;
            lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
            this.fieldResource = new VLookup("S_Resource_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "InfoAssignment.initLookup");
            return false;
        }
        this.bNew.setIcon(Env.getImageIcon((String)"New16.gif"));
        return true;
    }

    private void statInit() {
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelResourceType, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.labelResource, null);
        this.parameterPanel.add((Component)this.labelFrom, null);
        this.parameterPanel.add((Component)this.labelTo, null);
        this.parameterPanel.add((Component)this.fieldResourceType, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldResource, null);
        this.parameterPanel.add((Component)this.fieldFrom, null);
        this.parameterPanel.add((Component)this.fieldTo, null);
        this.parameterPanel.add((Component)this.bNew, null);
    }

    private void initInfo(String value, String whereClause) {
        StringBuilder where = new StringBuilder(s_assignmentWHERE);
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.prepareTable(s_assignmentLayout, s_assignmentFROM, where.toString(), "rt.Name,r.Name,ra.AssignDateFrom");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    protected String getSQLWhere() {
        Timestamp ts;
        Integer S_Resource_ID;
        StringBuilder sql = new StringBuilder();
        Integer S_ResourceType_ID = (Integer)this.fieldResourceType.getValue();
        if (S_ResourceType_ID != null) {
            sql.append(" AND rt.S_ResourceType_ID=").append(S_ResourceType_ID);
        }
        if ((S_Resource_ID = (Integer)this.fieldResource.getValue()) != null) {
            sql.append(" AND r.S_Resource_ID=").append(S_Resource_ID);
        }
        if ((ts = this.fieldFrom.getTimestamp()) != null) {
            sql.append(" AND TRUNC(ra.AssignDateFrom)>=").append(DB.TO_DATE((Timestamp)ts, (boolean)false));
        }
        if ((ts = this.fieldTo.getTimestamp()) != null) {
            sql.append(" AND TRUNC(ra.AssignDateTo)<=").append(DB.TO_DATE((Timestamp)ts, (boolean)false));
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    @Override
    protected void showHistory() {
    }

    @Override
    protected boolean hasHistory() {
        return false;
    }

    @Override
    protected void customize() {
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    @Override
    protected void zoom() {
    }

    @Override
    protected boolean hasZoom() {
        return false;
    }

    @Override
    protected void saveSelectionDetail() {
    }
}

