/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.compiere.grid.GridController;
import org.compiere.model.GridWindow;
import org.compiere.model.MRole;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;

public class GridSynchronizer
implements PropertyChangeListener,
StateChangeListener {
    private GridController parent;
    private GridController child;
    private GridWindow window;

    public GridSynchronizer(GridWindow window, GridController parent, GridController child) {
        this.window = window;
        this.parent = parent;
        this.child = child;
        parent.getMTab().addPropertyChangeListener((PropertyChangeListener)this);
        parent.getMTab().addStateChangeListener((StateChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MRole role = MRole.getDefault();
        this.child.query(false, 0, role.getMaxQueryRecords());
    }

    public void stateChange(StateChangeEvent event) {
        MRole role = MRole.getDefault();
        this.child.query(false, 0, role.getMaxQueryRecords());
    }

    public void activateChild() {
        this.window.initTab(this.window.getTabIndex(this.child.getMTab()));
        this.child.activate();
        MRole role = MRole.getDefault();
        this.child.query(false, 0, role.getMaxQueryRecords());
    }

    public GridController getChild() {
        return this.child;
    }
}

