/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.compiere.apps.ADialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCash;
import org.compiere.grid.VPaymentFormDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VPaymentFormCash
extends PaymentFormCash
implements ActionListener {
    private VPaymentFormDialog dialog;
    private CLabel bBankAccountLabel = new CLabel();
    private CComboBox bBankAccountCombo = new CComboBox();
    private CLabel bCashBookLabel = new CLabel();
    private CComboBox bCashBookCombo = new CComboBox();
    private CLabel bCurrencyLabel = new CLabel();
    private CComboBox bCurrencyCombo = new CComboBox();
    private VDate bDateField;
    private CLabel bDateLabel = new CLabel();
    private CLabel bAmountLabel = new CLabel();
    private VNumber bAmountField = new VNumber();

    public VPaymentFormCash(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.bDateField = new VDate("DateAcct", false, false, true, 15, "DateAcct");
        this.dialog = new VPaymentFormDialog((PaymentForm)this, windowNo);
        this.init();
        int C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)windowNo, (String)"C_Invoice_ID");
        MInvoice invoice_tmp = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        if (!invoice_tmp.isSOTrx()) {
            this.bAmountField.setValue(this.m_Amount.negate());
        } else {
            this.bAmountField.setValue(this.m_Amount);
        }
        invoice_tmp = null;
    }

    public void init() {
        GridBagLayout bPanelLayout = new GridBagLayout();
        this.bBankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.bCurrencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.dialog.getPanel().setLayout(bPanelLayout);
        this.bAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.bDateLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        if (this.m_Cash_As_Payment) {
            this.dialog.getPanel().add((Component)this.bBankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.dialog.getPanel().add((Component)this.bBankAccountCombo, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        } else {
            this.bCashBookLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_CashBook_ID"));
            this.dialog.getPanel().add((Component)this.bCashBookLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.dialog.getPanel().add((Component)this.bCashBookCombo, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        }
        this.dialog.getPanel().add((Component)this.bCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.bCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.bDateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.bDateField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.bAmountLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.bAmountField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
    }

    public void loadData() {
        super.loadData();
        this.bAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.bAmountField.setValue(this.m_mPayment.getPayAmt());
        }
        if (this.m_C_CashLine_ID != 0) {
            this.bAmountField.setValue(this.m_cashLine.getAmount());
        }
        this.bDateField.setValue(this.m_DateAcct);
        Integer C_Currency_ID = new Integer(this.m_C_Currency_ID);
        if (this.s_Currencies.containsKey(C_Currency_ID)) {
            Enumeration en = this.s_Currencies.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.bCurrencyCombo.addItem(this.s_Currencies.get(key));
            }
            this.bCurrencyCombo.addActionListener(this);
            this.bCurrencyCombo.setSelectedItem(this.s_Currencies.get(C_Currency_ID));
        } else {
            this.bCurrencyLabel.setVisible(false);
            this.bCurrencyCombo.setVisible(false);
        }
        ArrayList list = this.getBankAccountList();
        for (KeyNamePair pp : list) {
            this.bBankAccountCombo.addItem(pp);
        }
        if (this.selectedBankAccount != null) {
            this.bBankAccountCombo.setSelectedItem(this.selectedBankAccount);
        }
        list = this.getCashBookList();
        for (KeyNamePair pp : list) {
            this.bCashBookCombo.addItem(pp);
        }
        if (this.selectedCashBook != null) {
            this.bCashBookCombo.setSelectedItem(this.selectedCashBook);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bCurrencyCombo) {
            KeyNamePair pp = (KeyNamePair)this.bCurrencyCombo.getSelectedItem();
            BigDecimal amt = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)this.m_Amount, (int)this.m_C_Currency_ID, (int)pp.getKey(), (int)this.m_AD_Client_ID, (int)this.m_AD_Org_ID);
            this.bAmountField.setValue(amt);
        }
    }

    public boolean checkMandatory() {
        KeyNamePair kp;
        int C_BankAccount_ID = 0;
        boolean dataOK = true;
        if (this.m_Cash_As_Payment && (kp = (KeyNamePair)this.bBankAccountCombo.getSelectedItem()) != null) {
            C_BankAccount_ID = kp.getKey();
        }
        if (this.m_Cash_As_Payment && C_BankAccount_ID == 0 && C_BankAccount_ID == 0 && this.m_Cash_As_Payment) {
            ADialog.error(this.getWindowNo(), this.dialog, "FillMandatory", this.bBankAccountLabel.getText());
            dataOK = false;
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        Timestamp newDateAcct;
        boolean ok;
        KeyNamePair kp;
        int newC_CashBook_ID = this.m_C_CashBook_ID;
        int newC_BankAccount_ID = 0;
        if (this.m_Cash_As_Payment) {
            kp = (KeyNamePair)this.bBankAccountCombo.getSelectedItem();
            if (kp != null) {
                newC_BankAccount_ID = kp.getKey();
            }
        } else {
            kp = (KeyNamePair)this.bCashBookCombo.getSelectedItem();
            if (kp != null) {
                newC_CashBook_ID = kp.getKey();
            }
        }
        if (!(ok = this.save(newC_BankAccount_ID, newC_CashBook_ID, newDateAcct = (Timestamp)this.bDateField.getValue(), (BigDecimal)this.bAmountField.getValue(), trxName))) {
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            ADialog.info(this.getWindowNo(), this.dialog, "PaymentCreated", this.processMsg);
        }
        return ok;
    }

    public void showWindow() {
        this.dialog.setVisible(true);
    }

    public void closeWindow() {
        this.dialog.dispose();
    }

    public Object getWindow() {
        return this.dialog;
    }
}

